function onSay(cid, words, param, channel)

	local player = Player(cid)
    local tmp = param:split(",")

    if not(tmp[1]) then
		return doPlayerPopupFYI(cid,"Params:\n\nTurn the cast on: '!cast on'\n\nTurn the cast off: '!cast off'\n\nSet a cast password: '!cast password,YourPassword'\n\nSet a description: '!cast,desc,YourDescription'\n\nBan a viewer: '!cast ban,ViewerName'\n\nUnban a viwer: '!cast unban,ViewerName'\n\nBan list: '!cast bans'\n\nMute a viewer: '!cast mute,ViewerName'\n\nUnmute a viewer: '!cast unmute,ViewerName'\n\nMute list: '!cast mutes'\n\nList of viewers: '!cast viewers'\n\nCast status: '!cast status'")
    end

    if tmp[1] == "on" then
		if getPlayerCast(cid).status == false then
			doPlayerSetCastState(cid, true)
			db.query("UPDATE `players` SET `cast` = 1 WHERE `id` = " .. getPlayerGUID(cid) .. ";")
			doPlayerSendTextMessage(cid, 21, "You have started casting.")
		else
			doPlayerSetCastState(cid, false)
			doPlayerSendTextMessage(cid, 21, "You have stopped casting.")
		end
		return false
    elseif tmp[1] == "off" then
		if getPlayerCast(cid).status == true then
			doPlayerSetCastState(cid, false)
			db.query("UPDATE `players` SET `cast` = 0 WHERE `id` = " .. getPlayerGUID(cid) .. ";")
			doPlayerSendTextMessage(cid, 21, "You have stopped casting.")
		else
			doPlayerSetCastState(cid, true)
			doPlayerSendTextMessage(cid, 21, "You have started casting.")
		end
		return false
    elseif isInArray({"pass", "password", "p"}, tmp[1]) then
        if not(tmp[2]) then
            return doPlayerSendCancel(cid, "You need to set a password")
        end

        if tmp[2]:len() > 10 then
            return doPlayerSendCancel(cid, "The password is too long. (Max.: 10 letters)")
        end

        if tmp[2] == "off" then
            doPlayerSetCastPassword(cid, "")
            doPlayerSendTextMessage(cid, MESSAGE_STATUS_CONSOLE_BLUE, "Cast password has been removed.")
        else
            doPlayerSetCastPassword(cid, tmp[2])
			doPlayerSendTextMessage(cid, MESSAGE_STATUS_CONSOLE_BLUE, "Cast password has been changed to: "..tmp[2])
        end
		return false
    elseif isInArray({"desc", "description", "d"}, tmp[1]) then
        local d = param:gsub(tmp[1]..(tmp[2] and " " or ""), "")

        if not(d) or d:len() == 0 then
            return doPlayerSendCancel(cid, "You need to specify a description.")
        end

        if d:len() > 50 then
            return doPlayerSendCancel(cid, "The description is too long. (Max.: 50 letters)")
        end

        doPlayerSendTextMessage(cid, MESSAGE_STATUS_CONSOLE_BLUE, "Cast description was set to: ")
        doPlayerSendTextMessage(cid, MESSAGE_STATUS_CONSOLE_BLUE, d)
        doPlayerSetCastDescription(cid, d)
		return false
    elseif tmp[1] == "ban" then
        if not(tmp[2]) then
            return doPlayerSendCancel(cid, "Specify a spectator that you want to ban.")
        end

        if doPlayerAddCastBan(cid, tmp[2]) then
            doPlayerSendTextMessage(cid, MESSAGE_INFO_DESCR, "Spectator '" .. tmp[2] .. "' has been banned.")
        else
            doPlayerSendTextMessage(cid, MESSAGE_INFO_DESCR, "Spectator '" .. tmp[2] .. "' could not be banned.")
        end
		return false
    elseif tmp[1] == "unban" then
        if not(tmp[2]) then
            return doPlayerSendCancel(cid, "Specify the person you want to unban.")
        end

        if doPlayerRemoveCastBan(cid, tmp[2]) then
            doPlayerSendTextMessage(cid, MESSAGE_INFO_DESCR, "Spectator '" .. tmp[2] .. "' has been unbanned.")
        else
            doPlayerSendTextMessage(cid, MESSAGE_INFO_DESCR, "Spectator '" .. tmp[2] .. "' could not be unbanned.")
        end
		return false
    elseif param == "bans" then
        local t = getCastBans(cid)
        local text = "Cast Bans:\n\n"
		if t ~= nil then
			for k, v in pairs(t) do
				text = text .. "*" .. v.name .. "\n"
			end
		end
        if text == "Cast Bans:\n\n" then
            text = text .. "No bans."
        end
        doShowTextDialog(cid, 2597, text)
		return false
    elseif tmp[1] == "mute" then
        if not(tmp[2]) then
            return doPlayerSendCancel(cid, "Specify a spectator that you want to mute.")
        end

        if doPlayerAddCastMute(cid, tmp[2]) then
            doPlayerSendTextMessage(cid, MESSAGE_INFO_DESCR, "Spectator '" .. tmp[2] .. "' has been muted.")
        else
            doPlayerSendTextMessage(cid, MESSAGE_INFO_DESCR, "Spectator '" .. tmp[2] .. "' could not be muted.")
        end
		return false
    elseif tmp[1] == "unmute" then
        if not(tmp[2]) then
            return doPlayerSendCancel(cid, "Specify the person you want to unmute.")
        end

        if doPlayerRemoveCastMute(cid, tmp[2]) then
            doPlayerSendTextMessage(cid, MESSAGE_INFO_DESCR, "Spectator '" .. tmp[2] .. "' has been unmuted.")
        else
            doPlayerSendTextMessage(cid, MESSAGE_INFO_DESCR, "Spectator '" .. tmp[2] .. "' could not be unmuted.")
        end
		return false
    elseif param == "mutes" then
        local t = getCastMutes(cid)
        local text = "Cast Mutes:\n\n"
		if t ~= nil then
			for k, v in pairs(t) do
				text = text .. "*" .. v.name .. "\n"
			end
		end
        if text == "Cast Bans:\n\n" then
            text = text .. "No mutes."
        end
        doShowTextDialog(cid, 2597, text)
		return false
    elseif param == "viewers" then
	
        local t = getCastViewers(cid)
        local text, count = "Cast Viewers:\n#Viewers: |COUNT|\n\n", 0
		if t ~= nil then
			for _,v in pairs(t) do
				count = count + 1
				text = text .. "*" .. v.name .."\n"
			end
		end
        if text == "Cast Viewers:\n#Viewers: |COUNT|\n\n" then text = "Cast Viewers:\n\nNo viewers." end
        text = text:gsub("|COUNT|", count)
        doShowTextDialog(cid, 2597, text)
		return false
    elseif param == "status" then
        local t, c = getCastViewers(cid), getPlayerCast(cid)
        local count = 0
        for _,v in pairs(t) do count = count + 1 end

        doShowTextDialog(cid, 2597, "Cast Status:\n\n*Viewers:\n      " .. count .. "\n*Description:\n      "..(c.description == "" and "Not set" or c.description).."\n*Password:\n      " .. (c.password == "" and "Not set" or "Set - '"..c.password.."'"))
		return false
    end
    return true
end
