local config = {
	[2285] = {
		items = {
			{itemId = 2356}
		},
		storage = Storage.DjinnWar.EfreetFaction.Mission03,
		formerValue = 1,
		newValue = 2,
		needItem = {itemId = 2344},
		effect = CONST_ME_MAGIC_BLUE
	},
	[2286] = {
		items = {
			{itemId = 2318}
		},
		storage = Storage.QuestChests.FamilyBrooch
	},
	[3002] = {
		items = {
			{itemId = 2147, count = 6}
		},
		storage = Storage.QuestChests.SixRubiesQuest
	},
	[3003] = {
		items = {
			{itemId = 4858}
		},
		storage = Storage.ExplorerSociety.QuestLine,
		formerValue = 27,
		newValue = 28
	},
	[3004] = {
		items = {
			{itemId = 2229}, {itemId = 2151, count = 2}, {itemId = 2165}, {itemId = 2230}, {itemId = 2091, actionId = 6010}
		},
		storage = Storage.QuestChests.ParchmentRoomQuest
	},
	[3005] = {
		items = {
			{itemId = 4857}
		},
		storage = Storage.ExplorerSociety.QuestLine,
		formerValue = 30,
		newValue = 31
	},
	[3007] = {
		items = {
			{itemId = 15389}
		},
		storage = Storage.ExplorerSociety.QuestLine,
		formerValue = 33,
		newValue = 34
	},
	[3009] = {
		items = {
			{itemId = 4855}
		},
		storage = Storage.ExplorerSociety.QuestLine,
		formerValue = 36,
		newValue = 37
	},
	[3010] = {
		items = {
			{itemId = 4853}
		},
		storage = Storage.ExplorerSociety.QuestLine,
		formerValue = 42,
		newValue = 43
	},
	[3012] = {
		items = {
			{itemId = 4852}
		},
		storage = Storage.ExplorerSociety.QuestLine,
		formerValue = 39,
		newValue = 40
	},
	[3014] = {
		items = {
			{itemId = 4847}
		},
		storage = Storage.ExplorerSociety.QuestLine,
		formerValue = 49,
		newValue = 50
	},
	[3018] = {
		items = {
			{itemId = 2332}
		},
		storage = Storage.postman.Mission08,
		formerValue = 1,
		newValue = 2
	},
	[3020] = {
		items = {
			{itemId = 7503}
		},
		storage = Storage.TravellingTrader.Mission02,
		formerValue = 3,
		newValue = 4
	},
	[3024] = {
		items = {
			{itemId = 2356}
		},
		storage = Storage.DjinnWar.MaridFaction.Mission03,
		formerValue = 1,
		newValue = 2,
		needItem = {itemId = 2344},
		effect = CONST_ME_MAGIC_RED
	},
	[3027] = {
		items = {
			{itemId = 2487}
		},
		storage = Storage.QuestChests.BlackKnightTreeCrownArmor
	},
	[3062] = {
		items = {
			{itemId = 8262}
		},
		storage = Storage.QuestChests.KosheiAmulet1
	},
	[3064] = {
		items = {
			{itemId = 8264}
		},
		storage = Storage.QuestChests.KosheiAmulet2
	},
	[3084] = {
		items = {
			{itemId = 9744}
		},
		storage = Storage.InServiceofYalahar.MatrixReward
	},
	[3085] = {
		items = {
			{itemId = 9743}
		},
		storage = Storage.InServiceofYalahar.MatrixReward
	},
	[3112] = {
		items = {
			{itemId = 1954, text = '<the paper is old and tattered, you can only make out a signature:> Tylaf, apprentice of Hjaern'}
		},
		storage = Storage.TheIceIslands.Questline,
		formerValue = 35,
		newValue = 36,
		missionStorage = { key = Storage.TheIceIslands.Mission09, value = 2 }
	},
	[3114] = {
		items = {
			{itemId = 6124}
		},
		storage = Storage.ExplorerSociety.QuestLine,
		formerValue = 63,
		newValue = 64
	},
	[3116] = {
		items = {
			{itemId = 2330}
		},
		storage = Storage.postman.Mission09,
		formerValue = 1,
		newValue = 2
	},
	[3120] = {
		items = {
			{itemId = 2331}
		},
		storage = Storage.postman.Mission05,
		formerValue = 1,
		newValue = 2
	},
	[3162] = {
		items = {
			{itemId = 11101}
		},
		storage = Storage.ChildrenoftheRevolution.Questline,
		formerValue = 1,
		newValue = 2,
		say = 'A batch of documents has been stashed in the shelf. These might be of interest to Zalamon.',
		effect = CONST_ME_POFF
	},
	[3311] = {
		items = {
			{itemId = 2089, actionId = 3301}
		},
		storage = Storage.QuestChests.OutlawCampKey1
	},
	[3312] = {
		items = {
			{itemId = 2088, actionId = 3302}
		},
		storage = Storage.QuestChests.OutlawCampKey2
	},
	[3313] = {
		items = {
			{itemId = 2089, actionId = 3303}
		},
		storage = Storage.QuestChests.OutlawCampKey3
	},
	[4010] = {
		items = {
			{itemId = 4843}
		},
		storage = Storage.TheApeCity.HolyApeHair
	},
	[5556] = {
		items = {
			{itemId = 2463}
		},
		storage = Storage.GhostShipQuest
	},
	[9055] = {
		items = {
			{itemId = 2519}
		},
		storage = Storage.QuestChests.BlackKnightTreeCrownShield
	},
	[9136] = {
		items = {
			{itemId = 2091, actionId = 3980}
		},
		storage = Storage.QuestChests.DeeperFibulaKey
	},
	[9185] = {
		items = {
			{itemId = 2134}, {itemId = 2147, count = 2}, {itemId = 2145, count = 3}
		},
		storage = Storage.QuestChests.SilverBrooch
	},
	[9196] = {
		items = {
			{itemId = 2088, actionId = 5010}
		},
		storage = Storage.QuestChests.BlackKnightTreeKey
	},
	[9226] = {
		items = {
			{itemId = 2503}
		},
		storage = Storage.SamsOldBackpack,
		formerValue = 2,
		newValue = 3
	},
	[12125] = {
		items = {
			{itemId = 4850}
		},
		storage = Storage.HydraEggQuest
	},
	[12126] = {
		items = {
			{itemId = 4840, decay = true}
		},
		storage = Storage.TheApeCity.WitchesCapSpot,
		time = true
	},
	[12331] = {
		items = {
			{itemId = 11076}
		},
		storage = Storage.UnnaturalSelection.Mission01,
		formerValue = 1,
		newValue = 2,
		say = 'You dig out a skull from the pile of bones. That must be the skull Lazaran talked about.'
	},
	[12507] = {
		items = {
			{itemId = 8766}
		},
		storage = Storage.thievesGuild.Mission06,
		formerValue = 2,
		newValue = 3,
		say = 'To buy some time you replace the fish with a piece of carrot.'
	},
	[12578] = {
		items = {
			{itemId = 7736}
		},
		storage = Storage.secretService.RottenTree
	},
	[50032] = {
		items = {
			{itemId = 2798}
		},
		storage = Storage.BloodHerbQuest
	},
	[50112] = {
		items = {
			{itemId = 2789, count = 10}
		},
		storage = Storage.hiddenCityOfBeregar.BrownMushrooms
	},
	[50125] = {
		items = {
			{itemId = 14348}
		},
		storage = Storage.hiddenCityOfBeregar.JusticeForAll,
		formerValue = 3,
		newValue = 4
	}
}

function onUse(player, item, fromPosition, target, toPosition, isHotkey)
	local useItem = config[item.uid]
	if not useItem then
		return true
	end

	if (useItem.time and player:getStorageValue(useItem.storage) > os.time())
			or player:getStorageValue(useItem.storage) ~= (useItem.formerValue or -1) then
		player:sendTextMessage(MESSAGE_EVENT_ADVANCE, 'The ' .. ItemType(item.itemid):getName() .. ' is empty.')
		return true
	end

	if useItem.needItem then
		if player:getItemCount(useItem.needItem.itemId) < (useItem.needItem.count or 1) then
			return false
		end
	end

	local items, reward = useItem.items
	local size = #items
	if size == 1 then
		reward = Game.createItem(items[1].itemId, items[1].count or 1)
	end

	local result = ''
	if reward then
		local ret = ItemType(reward.itemid)
		if ret:isRune() then
			result = ret:getArticle() .. ' ' ..  ret:getName() .. ' (' .. reward.type .. ' charges)'
		elseif reward:getCount() > 1 then
			result = reward:getCount() .. ' ' .. ret:getPluralName()
		elseif ret:getArticle() ~= '' then
			result = ret:getArticle() .. ' ' .. ret:getName()
		else
			result = ret:getName()
		end

		if items[1].actionId then
			reward:setActionId(items[1].actionId)
		end

		if items[1].text then
			reward:setText(items[1].text)
		end

		if items[1].decay then
			reward:decay()
		end

	else
		if size > 8 then
			reward = Game.createItem(1988, 1)
		else
			reward = Game.createItem(1987, 1)
		end

		for i = 1, size do
			local tmp = Game.createItem(items[i].itemId, items[i].count or 1)
			if reward:addItemEx(tmp) ~= RETURNVALUE_NOERROR then
				print('[Warning] QuestSystem:', 'Could not add quest reward to container')
			else
				if items[i].actionId then
					tmp:setActionId(items[i].actionId)
				end

				if items[i].text then
					tmp:setText(items[i].text)
				end

				if items[i].decay then
					tmp:decay()
				end

			end
		end
		local ret = ItemType(reward.itemid)
		result = ret:getArticle() .. ' ' .. ret:getName()
	end

	if player:addItemEx(reward) ~= RETURNVALUE_NOERROR then
		local weight = reward:getWeight()
		if player:getFreeCapacity() < weight then
			player:sendCancelMessage('You have found ' .. result .. '. Weighing ' .. string.format('%.2f', (weight / 100)) .. ' oz, it is too heavy.')
		else
			player:sendCancelMessage('You have found ' .. result .. ', but you have no room to take it.')
		end
		return true
	end

	if useItem.say then
		player:say(useItem.say, TALKTYPE_MONSTER_SAY)
	end

	if useItem.needItem then
		player:removeItem(useItem.needItem.itemId, useItem.needItem.count or 1)
	end

	if useItem.effect then
		toPosition:sendMagicEffect(useItem.effect)
	end

	if useItem.missionStorage then
		player:setStorageValue(useItem.missionStorage.key, useItem.missionStorage.value)
	end

	player:sendTextMessage(MESSAGE_EVENT_ADVANCE, 'You have found ' .. result .. '.')
	if useItem.time then
		player:setStorageValue(useItem.storage, os.time() + 86400)
	else
		player:setStorageValue(useItem.storage, useItem.newValue or 1)
	end
	return true
end
