webpackJsonp([0],{

/***/ 1:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var Direction = exports.Direction = undefined;
(function (Direction) {
    Direction[Direction["North"] = 0] = "North";
    Direction[Direction["East"] = 1] = "East";
    Direction[Direction["South"] = 2] = "South";
    Direction[Direction["West"] = 3] = "West";
})(Direction || (exports.Direction = Direction = {}));
var GameFeature = exports.GameFeature = undefined;
(function (GameFeature) {
    GameFeature[GameFeature["GameProtocolChecksum"] = 1] = "GameProtocolChecksum";
    GameFeature[GameFeature["GameAccountNames"] = 2] = "GameAccountNames";
    GameFeature[GameFeature["GameChallengeOnLogin"] = 3] = "GameChallengeOnLogin";
    GameFeature[GameFeature["GamePenalityOnDeath"] = 4] = "GamePenalityOnDeath";
    GameFeature[GameFeature["GameNameOnNpcTrade"] = 5] = "GameNameOnNpcTrade";
    GameFeature[GameFeature["GameDoubleFreeCapacity"] = 6] = "GameDoubleFreeCapacity";
    GameFeature[GameFeature["GameDoubleExperience"] = 7] = "GameDoubleExperience";
    GameFeature[GameFeature["GameTotalCapacity"] = 8] = "GameTotalCapacity";
    GameFeature[GameFeature["GameSkillsBase"] = 9] = "GameSkillsBase";
    GameFeature[GameFeature["GamePlayerRegenerationTime"] = 10] = "GamePlayerRegenerationTime";
    GameFeature[GameFeature["GameChannelPlayerList"] = 11] = "GameChannelPlayerList";
    GameFeature[GameFeature["GamePlayerMounts"] = 12] = "GamePlayerMounts";
    GameFeature[GameFeature["GameEnvironmentEffect"] = 13] = "GameEnvironmentEffect";
    GameFeature[GameFeature["GameCreatureEmblems"] = 14] = "GameCreatureEmblems";
    GameFeature[GameFeature["GameItemAnimationPhase"] = 15] = "GameItemAnimationPhase";
    GameFeature[GameFeature["GameMagicEffectU16"] = 16] = "GameMagicEffectU16";
    GameFeature[GameFeature["GamePlayerMarket"] = 17] = "GamePlayerMarket";
    GameFeature[GameFeature["GameSpritesU32"] = 18] = "GameSpritesU32";
    // 19 unused
    GameFeature[GameFeature["GameOfflineTrainingTime"] = 20] = "GameOfflineTrainingTime";
    GameFeature[GameFeature["GamePurseSlot"] = 21] = "GamePurseSlot";
    GameFeature[GameFeature["GameFormatCreatureName"] = 22] = "GameFormatCreatureName";
    GameFeature[GameFeature["GameSpellList"] = 23] = "GameSpellList";
    GameFeature[GameFeature["GameClientPing"] = 24] = "GameClientPing";
    GameFeature[GameFeature["GameExtendedClientPing"] = 25] = "GameExtendedClientPing";
    GameFeature[GameFeature["GameDoubleHealth"] = 28] = "GameDoubleHealth";
    GameFeature[GameFeature["GameDoubleSkills"] = 29] = "GameDoubleSkills";
    GameFeature[GameFeature["GameChangeMapAwareRange"] = 30] = "GameChangeMapAwareRange";
    GameFeature[GameFeature["GameMapMovePosition"] = 31] = "GameMapMovePosition";
    GameFeature[GameFeature["GameAttackSeq"] = 32] = "GameAttackSeq";
    GameFeature[GameFeature["GameBlueNpcNameColor"] = 33] = "GameBlueNpcNameColor";
    GameFeature[GameFeature["GameDiagonalAnimatedText"] = 34] = "GameDiagonalAnimatedText";
    GameFeature[GameFeature["GameLoginPending"] = 35] = "GameLoginPending";
    GameFeature[GameFeature["GameNewSpeedLaw"] = 36] = "GameNewSpeedLaw";
    GameFeature[GameFeature["GameForceFirstAutoWalkStep"] = 37] = "GameForceFirstAutoWalkStep";
    GameFeature[GameFeature["GameMinimapRemove"] = 38] = "GameMinimapRemove";
    GameFeature[GameFeature["GameDoubleShopSellAmount"] = 39] = "GameDoubleShopSellAmount";
    GameFeature[GameFeature["GameContainerPagination"] = 40] = "GameContainerPagination";
    GameFeature[GameFeature["GameThingMarks"] = 41] = "GameThingMarks";
    GameFeature[GameFeature["GameLooktypeU16"] = 42] = "GameLooktypeU16";
    GameFeature[GameFeature["GamePlayerStamina"] = 43] = "GamePlayerStamina";
    GameFeature[GameFeature["GamePlayerAddons"] = 44] = "GamePlayerAddons";
    GameFeature[GameFeature["GameMessageStatements"] = 45] = "GameMessageStatements";
    GameFeature[GameFeature["GameMessageLevel"] = 46] = "GameMessageLevel";
    GameFeature[GameFeature["GameNewFluids"] = 47] = "GameNewFluids";
    GameFeature[GameFeature["GamePlayerStateU16"] = 48] = "GamePlayerStateU16";
    GameFeature[GameFeature["GameNewOutfitProtocol"] = 49] = "GameNewOutfitProtocol";
    GameFeature[GameFeature["GamePVPMode"] = 50] = "GamePVPMode";
    GameFeature[GameFeature["GameWritableDate"] = 51] = "GameWritableDate";
    GameFeature[GameFeature["GameAdditionalVipInfo"] = 52] = "GameAdditionalVipInfo";
    GameFeature[GameFeature["GameBaseSkillU16"] = 53] = "GameBaseSkillU16";
    GameFeature[GameFeature["GameCreatureIcons"] = 54] = "GameCreatureIcons";
    GameFeature[GameFeature["GameHideNpcNames"] = 55] = "GameHideNpcNames";
    GameFeature[GameFeature["GameSpritesAlphaChannel"] = 56] = "GameSpritesAlphaChannel";
    GameFeature[GameFeature["GamePremiumExpiration"] = 57] = "GamePremiumExpiration";
    GameFeature[GameFeature["GameBrowseField"] = 58] = "GameBrowseField";
    GameFeature[GameFeature["GameEnhancedAnimations"] = 59] = "GameEnhancedAnimations";
    GameFeature[GameFeature["GameOGLInformation"] = 60] = "GameOGLInformation";
    GameFeature[GameFeature["GameMessageSizeCheck"] = 61] = "GameMessageSizeCheck";
    GameFeature[GameFeature["GamePreviewState"] = 62] = "GamePreviewState";
    GameFeature[GameFeature["GameLoginPacketEncryption"] = 63] = "GameLoginPacketEncryption";
    GameFeature[GameFeature["GameClientVersion"] = 64] = "GameClientVersion";
    GameFeature[GameFeature["GameContentRevision"] = 65] = "GameContentRevision";
    GameFeature[GameFeature["GameExperienceBonus"] = 66] = "GameExperienceBonus";
    GameFeature[GameFeature["GameAuthenticator"] = 67] = "GameAuthenticator";
    GameFeature[GameFeature["GameUnjustifiedPoints"] = 68] = "GameUnjustifiedPoints";
    GameFeature[GameFeature["GameSessionKey"] = 69] = "GameSessionKey";
    GameFeature[GameFeature["GameDeathType"] = 70] = "GameDeathType";
    GameFeature[GameFeature["GameIdleAnimations"] = 71] = "GameIdleAnimations";
    GameFeature[GameFeature["GameKeepUnawareTiles"] = 72] = "GameKeepUnawareTiles";
    GameFeature[GameFeature["GameIngameStore"] = 73] = "GameIngameStore";
    GameFeature[GameFeature["GameIngameStoreHighlights"] = 74] = "GameIngameStoreHighlights";
    GameFeature[GameFeature["GameIngameStoreServiceType"] = 75] = "GameIngameStoreServiceType";
    GameFeature[GameFeature["GameAdditionalSkills"] = 76] = "GameAdditionalSkills";
    GameFeature[GameFeature["LastGameFeature"] = 101] = "LastGameFeature";
})(GameFeature || (exports.GameFeature = GameFeature = {}));
var FrameGroupType = exports.FrameGroupType = undefined;
(function (FrameGroupType) {
    FrameGroupType[FrameGroupType["FrameGroupDefault"] = 0] = "FrameGroupDefault";
    FrameGroupType[FrameGroupType["FrameGroupIdle"] = 0] = "FrameGroupIdle";
    FrameGroupType[FrameGroupType["FrameGroupMoving"] = 1] = "FrameGroupMoving";
})(FrameGroupType || (exports.FrameGroupType = FrameGroupType = {}));
var DatThingCategory = exports.DatThingCategory = undefined;
(function (DatThingCategory) {
    DatThingCategory[DatThingCategory["ThingCategoryItem"] = 0] = "ThingCategoryItem";
    DatThingCategory[DatThingCategory["ThingCategoryCreature"] = 1] = "ThingCategoryCreature";
    DatThingCategory[DatThingCategory["ThingCategoryEffect"] = 2] = "ThingCategoryEffect";
    DatThingCategory[DatThingCategory["ThingCategoryMissile"] = 3] = "ThingCategoryMissile";
    DatThingCategory[DatThingCategory["ThingInvalidCategory"] = 4] = "ThingInvalidCategory";
    DatThingCategory[DatThingCategory["ThingLastCategory"] = 4] = "ThingLastCategory";
})(DatThingCategory || (exports.DatThingCategory = DatThingCategory = {}));
var DatThingAttr = exports.DatThingAttr = undefined;
(function (DatThingAttr) {
    DatThingAttr[DatThingAttr["ThingAttrGround"] = 0] = "ThingAttrGround";
    DatThingAttr[DatThingAttr["ThingAttrGroundBorder"] = 1] = "ThingAttrGroundBorder";
    DatThingAttr[DatThingAttr["ThingAttrOnBottom"] = 2] = "ThingAttrOnBottom";
    DatThingAttr[DatThingAttr["ThingAttrOnTop"] = 3] = "ThingAttrOnTop";
    DatThingAttr[DatThingAttr["ThingAttrContainer"] = 4] = "ThingAttrContainer";
    DatThingAttr[DatThingAttr["ThingAttrStackable"] = 5] = "ThingAttrStackable";
    DatThingAttr[DatThingAttr["ThingAttrForceUse"] = 6] = "ThingAttrForceUse";
    DatThingAttr[DatThingAttr["ThingAttrMultiUse"] = 7] = "ThingAttrMultiUse";
    DatThingAttr[DatThingAttr["ThingAttrWritable"] = 8] = "ThingAttrWritable";
    DatThingAttr[DatThingAttr["ThingAttrWritableOnce"] = 9] = "ThingAttrWritableOnce";
    DatThingAttr[DatThingAttr["ThingAttrFluidContainer"] = 10] = "ThingAttrFluidContainer";
    DatThingAttr[DatThingAttr["ThingAttrSplash"] = 11] = "ThingAttrSplash";
    DatThingAttr[DatThingAttr["ThingAttrNotWalkable"] = 12] = "ThingAttrNotWalkable";
    DatThingAttr[DatThingAttr["ThingAttrNotMoveable"] = 13] = "ThingAttrNotMoveable";
    DatThingAttr[DatThingAttr["ThingAttrBlockProjectile"] = 14] = "ThingAttrBlockProjectile";
    DatThingAttr[DatThingAttr["ThingAttrNotPathable"] = 15] = "ThingAttrNotPathable";
    DatThingAttr[DatThingAttr["ThingAttrPickupable"] = 16] = "ThingAttrPickupable";
    DatThingAttr[DatThingAttr["ThingAttrHangable"] = 17] = "ThingAttrHangable";
    DatThingAttr[DatThingAttr["ThingAttrHookSouth"] = 18] = "ThingAttrHookSouth";
    DatThingAttr[DatThingAttr["ThingAttrHookEast"] = 19] = "ThingAttrHookEast";
    DatThingAttr[DatThingAttr["ThingAttrRotateable"] = 20] = "ThingAttrRotateable";
    DatThingAttr[DatThingAttr["ThingAttrLight"] = 21] = "ThingAttrLight";
    DatThingAttr[DatThingAttr["ThingAttrDontHide"] = 22] = "ThingAttrDontHide";
    DatThingAttr[DatThingAttr["ThingAttrTranslucent"] = 23] = "ThingAttrTranslucent";
    DatThingAttr[DatThingAttr["ThingAttrDisplacement"] = 24] = "ThingAttrDisplacement";
    DatThingAttr[DatThingAttr["ThingAttrElevation"] = 25] = "ThingAttrElevation";
    DatThingAttr[DatThingAttr["ThingAttrLyingCorpse"] = 26] = "ThingAttrLyingCorpse";
    DatThingAttr[DatThingAttr["ThingAttrAnimateAlways"] = 27] = "ThingAttrAnimateAlways";
    DatThingAttr[DatThingAttr["ThingAttrMinimapColor"] = 28] = "ThingAttrMinimapColor";
    DatThingAttr[DatThingAttr["ThingAttrLensHelp"] = 29] = "ThingAttrLensHelp";
    DatThingAttr[DatThingAttr["ThingAttrFullGround"] = 30] = "ThingAttrFullGround";
    DatThingAttr[DatThingAttr["ThingAttrLook"] = 31] = "ThingAttrLook";
    DatThingAttr[DatThingAttr["ThingAttrCloth"] = 32] = "ThingAttrCloth";
    DatThingAttr[DatThingAttr["ThingAttrMarket"] = 33] = "ThingAttrMarket";
    DatThingAttr[DatThingAttr["ThingAttrUsable"] = 34] = "ThingAttrUsable";
    DatThingAttr[DatThingAttr["ThingAttrWrapable"] = 35] = "ThingAttrWrapable";
    DatThingAttr[DatThingAttr["ThingAttrUnwrapable"] = 36] = "ThingAttrUnwrapable";
    DatThingAttr[DatThingAttr["ThingAttrTopEffect"] = 37] = "ThingAttrTopEffect";
    DatThingAttr[DatThingAttr["ThingAttrBones"] = 38] = "ThingAttrBones";
    // additional
    DatThingAttr[DatThingAttr["ThingAttrOpacity"] = 100] = "ThingAttrOpacity";
    DatThingAttr[DatThingAttr["ThingAttrNotPreWalkable"] = 101] = "ThingAttrNotPreWalkable";
    DatThingAttr[DatThingAttr["ThingAttrFloorChange"] = 252] = "ThingAttrFloorChange";
    DatThingAttr[DatThingAttr["ThingAttrNoMoveAnimation"] = 253] = "ThingAttrNoMoveAnimation";
    DatThingAttr[DatThingAttr["ThingAttrChargeable"] = 254] = "ThingAttrChargeable";
    DatThingAttr[DatThingAttr["ThingLastAttr"] = 255] = "ThingLastAttr";
})(DatThingAttr || (exports.DatThingAttr = DatThingAttr = {}));
var OtbItemCategory = exports.OtbItemCategory = undefined;
(function (OtbItemCategory) {
    OtbItemCategory[OtbItemCategory["ItemCategoryInvalid"] = 0] = "ItemCategoryInvalid";
    OtbItemCategory[OtbItemCategory["ItemCategoryGround"] = 1] = "ItemCategoryGround";
    OtbItemCategory[OtbItemCategory["ItemCategoryContainer"] = 2] = "ItemCategoryContainer";
    OtbItemCategory[OtbItemCategory["ItemCategoryWeapon"] = 3] = "ItemCategoryWeapon";
    OtbItemCategory[OtbItemCategory["ItemCategoryAmmunition"] = 4] = "ItemCategoryAmmunition";
    OtbItemCategory[OtbItemCategory["ItemCategoryArmor"] = 5] = "ItemCategoryArmor";
    OtbItemCategory[OtbItemCategory["ItemCategoryCharges"] = 6] = "ItemCategoryCharges";
    OtbItemCategory[OtbItemCategory["ItemCategoryTeleport"] = 7] = "ItemCategoryTeleport";
    OtbItemCategory[OtbItemCategory["ItemCategoryMagicField"] = 8] = "ItemCategoryMagicField";
    OtbItemCategory[OtbItemCategory["ItemCategoryWritable"] = 9] = "ItemCategoryWritable";
    OtbItemCategory[OtbItemCategory["ItemCategoryKey"] = 10] = "ItemCategoryKey";
    OtbItemCategory[OtbItemCategory["ItemCategorySplash"] = 11] = "ItemCategorySplash";
    OtbItemCategory[OtbItemCategory["ItemCategoryFluid"] = 12] = "ItemCategoryFluid";
    OtbItemCategory[OtbItemCategory["ItemCategoryDoor"] = 13] = "ItemCategoryDoor";
    OtbItemCategory[OtbItemCategory["ItemCategoryDeprecated"] = 14] = "ItemCategoryDeprecated";
    OtbItemCategory[OtbItemCategory["ItemCategoryLast"] = 15] = "ItemCategoryLast";
})(OtbItemCategory || (exports.OtbItemCategory = OtbItemCategory = {}));
var OtbItemTypeAttr = exports.OtbItemTypeAttr = undefined;
(function (OtbItemTypeAttr) {
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrServerId"] = 16] = "ItemTypeAttrServerId";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrClientId"] = 17] = "ItemTypeAttrClientId";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrName"] = 18] = "ItemTypeAttrName";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrDesc"] = 19] = "ItemTypeAttrDesc";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrSpeed"] = 20] = "ItemTypeAttrSpeed";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrSlot"] = 21] = "ItemTypeAttrSlot";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrMaxItems"] = 22] = "ItemTypeAttrMaxItems";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrWeight"] = 23] = "ItemTypeAttrWeight";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrWeapon"] = 24] = "ItemTypeAttrWeapon";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrAmmunition"] = 25] = "ItemTypeAttrAmmunition";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrArmor"] = 26] = "ItemTypeAttrArmor";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrMagicLevel"] = 27] = "ItemTypeAttrMagicLevel";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrMagicField"] = 28] = "ItemTypeAttrMagicField";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrWritable"] = 29] = "ItemTypeAttrWritable";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrRotateTo"] = 30] = "ItemTypeAttrRotateTo";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrDecay"] = 31] = "ItemTypeAttrDecay";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrSpriteHash"] = 32] = "ItemTypeAttrSpriteHash";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrMinimapColor"] = 33] = "ItemTypeAttrMinimapColor";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttr07"] = 34] = "ItemTypeAttr07";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttr08"] = 35] = "ItemTypeAttr08";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrLight"] = 36] = "ItemTypeAttrLight";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrDecay2"] = 37] = "ItemTypeAttrDecay2";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrWeapon2"] = 38] = "ItemTypeAttrWeapon2";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrAmmunition2"] = 39] = "ItemTypeAttrAmmunition2";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrArmor2"] = 40] = "ItemTypeAttrArmor2";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrWritable2"] = 41] = "ItemTypeAttrWritable2";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrLight2"] = 42] = "ItemTypeAttrLight2";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrTopOrder"] = 43] = "ItemTypeAttrTopOrder";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrWrtiable3"] = 44] = "ItemTypeAttrWrtiable3";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrWareId"] = 45] = "ItemTypeAttrWareId";
    OtbItemTypeAttr[OtbItemTypeAttr["ItemTypeAttrLast"] = 46] = "ItemTypeAttrLast";
})(OtbItemTypeAttr || (exports.OtbItemTypeAttr = OtbItemTypeAttr = {}));
var OtbItemFlags = exports.OtbItemFlags = undefined;
(function (OtbItemFlags) {
    OtbItemFlags[OtbItemFlags["FlagBlockSolid"] = 1] = "FlagBlockSolid";
    OtbItemFlags[OtbItemFlags["FlagBlockProjectile"] = 2] = "FlagBlockProjectile";
    OtbItemFlags[OtbItemFlags["FlagBlockPathfind"] = 4] = "FlagBlockPathfind";
    OtbItemFlags[OtbItemFlags["FlagHasHeight"] = 8] = "FlagHasHeight";
    OtbItemFlags[OtbItemFlags["FlagUseable"] = 16] = "FlagUseable";
    OtbItemFlags[OtbItemFlags["FlagPickupable"] = 32] = "FlagPickupable";
    OtbItemFlags[OtbItemFlags["FlagMoveable"] = 64] = "FlagMoveable";
    OtbItemFlags[OtbItemFlags["FlagStackable"] = 128] = "FlagStackable";
    OtbItemFlags[OtbItemFlags["FlagFloorchangedown"] = 256] = "FlagFloorchangedown";
    OtbItemFlags[OtbItemFlags["FlagFloorchangenorth"] = 512] = "FlagFloorchangenorth";
    OtbItemFlags[OtbItemFlags["FlagFloorchangeeast"] = 1024] = "FlagFloorchangeeast";
    OtbItemFlags[OtbItemFlags["FlagFloorchangesouth"] = 2048] = "FlagFloorchangesouth";
    OtbItemFlags[OtbItemFlags["FlagFloorchangewest"] = 4096] = "FlagFloorchangewest";
    OtbItemFlags[OtbItemFlags["FlagAlwaysontop"] = 8192] = "FlagAlwaysontop";
    OtbItemFlags[OtbItemFlags["FlagReadable"] = 16384] = "FlagReadable";
    OtbItemFlags[OtbItemFlags["FlagRotatable"] = 32768] = "FlagRotatable";
    OtbItemFlags[OtbItemFlags["FlagHangable"] = 65536] = "FlagHangable";
    OtbItemFlags[OtbItemFlags["FlagVertical"] = 131072] = "FlagVertical";
    OtbItemFlags[OtbItemFlags["FlagHorizontal"] = 262144] = "FlagHorizontal";
    OtbItemFlags[OtbItemFlags["FlagCannotdecay"] = 524288] = "FlagCannotdecay";
    OtbItemFlags[OtbItemFlags["FlagAllowdistread"] = 1048576] = "FlagAllowdistread";
    OtbItemFlags[OtbItemFlags["FlagUnused"] = 2097152] = "FlagUnused";
    OtbItemFlags[OtbItemFlags["FlagClientcharges"] = 4194304] = "FlagClientcharges";
    OtbItemFlags[OtbItemFlags["FlagLookthrough"] = 8388608] = "FlagLookthrough";
    OtbItemFlags[OtbItemFlags["FlagAnimation"] = 16777216] = "FlagAnimation";
    OtbItemFlags[OtbItemFlags["FlagFulltile"] = 33554432] = "FlagFulltile";
    OtbItemFlags[OtbItemFlags["FlagForceuse"] = 67108864] = "FlagForceuse";
})(OtbItemFlags || (exports.OtbItemFlags = OtbItemFlags = {}));
var SpriteMask = exports.SpriteMask = undefined;
(function (SpriteMask) {
    SpriteMask[SpriteMask["SpriteMaskRed"] = 1] = "SpriteMaskRed";
    SpriteMask[SpriteMask["SpriteMaskGreen"] = 2] = "SpriteMaskGreen";
    SpriteMask[SpriteMask["SpriteMaskBlue"] = 3] = "SpriteMaskBlue";
    SpriteMask[SpriteMask["SpriteMaskYellow"] = 4] = "SpriteMaskYellow";
})(SpriteMask || (exports.SpriteMask = SpriteMask = {}));

/***/ }),

/***/ 11:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Point = exports.Point = function () {
    function Point() {
        var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
        var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

        _classCallCheck(this, Point);

        this.x = x;
        this.y = y;
    }

    _createClass(Point, [{
        key: "equals",
        value: function equals(otherPoint) {
            return this.x == otherPoint.x && this.y == otherPoint.y;
        }
    }, {
        key: "clone",
        value: function clone() {
            return new Point(this.x, this.y);
        }
    }, {
        key: "add",
        value: function add(point) {
            return new Point(this.x + point.x, this.y + point.y);
        }
    }, {
        key: "sub",
        value: function sub(point) {
            return new Point(this.x - point.x, this.y - point.y);
        }
    }, {
        key: "mul",
        value: function mul(ratio) {
            return new Point(this.x * ratio, this.y * ratio);
        }
    }]);

    return Point;
}();

/***/ }),

/***/ 13:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.g_resources = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _inputFile = __webpack_require__(22);

var _log = __webpack_require__(4);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

var Resources = function () {
    function Resources() {
        _classCallCheck(this, Resources);
    }

    _createClass(Resources, [{
        key: "openUrl",
        value: function openUrl(url) {
            return __awaiter(this, void 0, void 0, /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
                var get, response, uInt8Array;
                return regeneratorRuntime.wrap(function _callee2$(_context2) {
                    while (1) {
                        switch (_context2.prev = _context2.next) {
                            case 0:
                                get = function get(url) {
                                    return __awaiter(this, void 0, void 0, /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
                                        return regeneratorRuntime.wrap(function _callee$(_context) {
                                            while (1) {
                                                switch (_context.prev = _context.next) {
                                                    case 0:
                                                        return _context.abrupt("return", new Promise(function (resolve, reject) {
                                                            var xhr = new XMLHttpRequest();
                                                            xhr.responseType = 'arraybuffer';
                                                            xhr.onload = function (e) {
                                                                if (this.status >= 200 && this.status < 300) resolve(this.response);else reject('Response status: ' + this.status);
                                                            };
                                                            xhr.onerror = function (e) {
                                                                reject(e);
                                                            };
                                                            xhr.open('GET', url, true); //Async
                                                            xhr.send();
                                                        }));

                                                    case 1:
                                                    case "end":
                                                        return _context.stop();
                                                }
                                            }
                                        }, _callee, this);
                                    }));
                                };

                                _context2.prev = 1;
                                _context2.next = 4;
                                return get(url);

                            case 4:
                                response = _context2.sent;
                                uInt8Array = new Uint8Array(response);
                                return _context2.abrupt("return", new _inputFile.InputFile(new DataView(uInt8Array.buffer)));

                            case 9:
                                _context2.prev = 9;
                                _context2.t0 = _context2["catch"](1);

                                _log.Log.debug('failed to openFile', _context2.t0);
                                throw _context2.t0;

                            case 13:
                            case "end":
                                return _context2.stop();
                        }
                    }
                }, _callee2, this, [[1, 9]]);
            }));
        }
    }]);

    return Resources;
}();

var g_resources = new Resources();
exports.g_resources = g_resources;

/***/ }),

/***/ 14:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.OutputFile = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _fileStream = __webpack_require__(23);

var _dataBuffer = __webpack_require__(8);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var OutputFile = exports.OutputFile = function (_FileStream) {
    _inherits(OutputFile, _FileStream);

    function OutputFile() {
        _classCallCheck(this, OutputFile);

        var _this = _possibleConstructorReturn(this, (OutputFile.__proto__ || Object.getPrototypeOf(OutputFile)).call(this));

        _this.data = new _dataBuffer.DataBuffer();
        _this.offset = 0;
        return _this;
    }

    _createClass(OutputFile, [{
        key: "addU8",
        value: function addU8(value) {
            this.offset += this.data.addU8(value);
        }
    }, {
        key: "addU16",
        value: function addU16(value) {
            this.offset += this.data.addU16(value);
        }
    }, {
        key: "addU32",
        value: function addU32(value) {
            this.offset += this.data.addU32(value);
        }
    }, {
        key: "addString",
        value: function addString(value) {
            this.offset += this.data.addString(value);
        }
    }, {
        key: "add8",
        value: function add8(value) {
            this.offset += this.data.add8(value);
        }
    }, {
        key: "add16",
        value: function add16(value) {
            this.offset += this.data.add16(value);
        }
    }, {
        key: "add32",
        value: function add32(value) {
            this.offset += this.data.add32(value);
        }
    }, {
        key: "setU8",
        value: function setU8(offset, value) {
            this.data.setU8(offset, value);
        }
    }, {
        key: "setU32",
        value: function setU32(offset, value) {
            this.data.setU32(offset, value);
        }
    }]);

    return OutputFile;
}(_fileStream.FileStream);

/***/ }),

/***/ 15:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SpriteManager = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _sprite = __webpack_require__(19);

var _resources = __webpack_require__(13);

var _log = __webpack_require__(4);

var _const = __webpack_require__(1);

var _size = __webpack_require__(7);

var _outputFile = __webpack_require__(14);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

var SpriteManager = exports.SpriteManager = function () {
    function SpriteManager(m_client) {
        _classCallCheck(this, SpriteManager);

        this.m_client = m_client;
        this.m_signature = 0;
        this.m_sprites = [];
    }

    _createClass(SpriteManager, [{
        key: "loadSprFromUrl",
        value: function loadSprFromUrl(url) {
            return __awaiter(this, void 0, void 0, /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
                var fin;
                return regeneratorRuntime.wrap(function _callee$(_context) {
                    while (1) {
                        switch (_context.prev = _context.next) {
                            case 0:
                                _context.next = 2;
                                return _resources.g_resources.openUrl(url);

                            case 2:
                                fin = _context.sent;
                                return _context.abrupt("return", this.loadSpr(fin));

                            case 4:
                            case "end":
                                return _context.stop();
                        }
                    }
                }, _callee, this);
            }));
        }
    }, {
        key: "loadSpr",
        value: function loadSpr(spritesFile) {
            this.m_signature = 0;
            try {
                this.m_signature = spritesFile.getU32();
                var spritesCount = this.m_client.getFeature(_const.GameFeature.GameSpritesU32) ? spritesFile.getU32() : spritesFile.getU16();
                var spritesOffset = spritesFile.tell();
                for (var id = 1; id <= spritesCount; id++) {
                    spritesFile.seek((id - 1) * 4 + spritesOffset);
                    var spriteAddress = spritesFile.getU32();
                    if (spriteAddress == 0 || this.m_sprites[id]) {
                        continue;
                    }
                    spritesFile.seek(spriteAddress);
                    var sprite = new _sprite.Sprite(new _size.Size(SpriteManager.SPRITE_SIZE, SpriteManager.SPRITE_SIZE));
                    sprite.readFromSpr(spritesFile, this.m_client);
                    this.m_sprites[id] = sprite;
                }
                return true;
            } catch (e) {
                _log.Log.error("Failed to load sprites: %s", e);
                return false;
            }
        }
    }, {
        key: "saveSpr",
        value: function saveSpr() {
            var spritesFile = new _outputFile.OutputFile();
            spritesFile.addU32(this.m_signature);
            if (this.m_client.getFeature(_const.GameFeature.GameSpritesU32)) spritesFile.addU32(this.getSpritesCount());else spritesFile.addU16(this.getSpritesCount());
            var spritesOffset = spritesFile.tell();
            for (var i = 0; i < this.m_sprites.length; i++) {
                spritesFile.addU32(0);
            }
            for (var _i = 0; _i < this.m_sprites.length; _i++) {
                if (this.m_sprites[_i]) {
                    var sprite = this.m_sprites[_i];
                    var spriteAddress = spritesFile.tell();
                    spritesFile.setU32(spritesOffset + 4 * _i, spriteAddress);
                    sprite.writeToSpr(spritesFile, this.m_client);
                }
            }
            return spritesFile;
        }
    }, {
        key: "getSignature",
        value: function getSignature() {
            return this.m_signature;
        }
    }, {
        key: "setSignature",
        value: function setSignature(value) {
            return this.m_signature = value;
        }
    }, {
        key: "getSprites",
        value: function getSprites() {
            return this.m_sprites;
        }
    }, {
        key: "getSprite",
        value: function getSprite(index) {
            return this.m_sprites[index];
        }
    }, {
        key: "getSpritesCount",
        value: function getSpritesCount() {
            return this.m_sprites.length;
        }
    }]);

    return SpriteManager;
}();

SpriteManager.SPRITE_SIZE = 32;
SpriteManager.SPRITE_DATA_SIZE = SpriteManager.SPRITE_SIZE * SpriteManager.SPRITE_SIZE * 4;

/***/ }),

/***/ 19:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Sprite = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _color = __webpack_require__(20);

var _helpers = __webpack_require__(26);

var _dataBuffer = __webpack_require__(8);

var _const = __webpack_require__(1);

var _spriteManager = __webpack_require__(15);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Sprite = exports.Sprite = function () {
    function Sprite(size) {
        var pixels = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

        _classCallCheck(this, Sprite);

        this.m_size = size;
        if (pixels) {
            this.m_pixels = pixels;
        } else {
            this.m_pixels = new _dataBuffer.DataBuffer();
            this.m_pixels.reserve(size.area() * 4);
        }
    }

    _createClass(Sprite, [{
        key: "blit",
        value: function blit(dest, other) {
            var otherPixels = other.getPixels();
            for (var p = 0; p < other.getPixelsCount(); ++p) {
                var x = (0, _helpers.toInt)(p % other.getWidth());
                var y = (0, _helpers.toInt)(p / other.getWidth());
                var pos = (dest.y + y) * (0, _helpers.toInt)(this.m_size.width()) + (dest.x + x);
                var otherPixel = otherPixels.getRgbaPixel(p);
                if (otherPixel.a != 0) {
                    this.m_pixels.setRgbaPixel(pos, otherPixel);
                } else {
                    this.m_pixels.reserveRgbaPixel(pos);
                }
            }
        }
    }, {
        key: "overwriteMask",
        value: function overwriteMask(color) {
            var insideColor = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _color.Color.white;
            var outsideColor = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _color.Color.alpha;
        }
    }, {
        key: "getWidth",
        value: function getWidth() {
            return this.m_size.width();
        }
    }, {
        key: "getHeight",
        value: function getHeight() {
            return this.m_size.height();
        }
    }, {
        key: "getPixel",
        value: function getPixel(x, y) {
            return this.m_pixels.getRgbaPixel(y * this.m_size.width() + x);
        }
    }, {
        key: "getPixelsCount",
        value: function getPixelsCount() {
            return this.m_size.area();
        }
    }, {
        key: "getPixels",
        value: function getPixels() {
            return this.m_pixels;
        }
    }, {
        key: "readFromSpr",
        value: function readFromSpr(inputFile, client) {
            this.m_pixels.clear();
            // skip color key
            inputFile.getU8();
            inputFile.getU8();
            inputFile.getU8();
            var pixelDataSize = inputFile.getU16();
            var writePos = 0;
            var read = 0;
            var useAlpha = client.getFeature(_const.GameFeature.GameSpritesAlphaChannel);
            var channels = useAlpha ? 4 : 3;
            // decompress pixels
            while (read < pixelDataSize && writePos < _spriteManager.SpriteManager.SPRITE_DATA_SIZE) {
                var transparentPixels = inputFile.getU16();
                var coloredPixels = inputFile.getU16();
                for (var i = 0; i < transparentPixels && writePos < _spriteManager.SpriteManager.SPRITE_DATA_SIZE; i++) {
                    this.m_pixels.addU8(0x00);
                    this.m_pixels.addU8(0x00);
                    this.m_pixels.addU8(0x00);
                    this.m_pixels.addU8(0x00);
                    writePos += 4;
                }
                for (var _i = 0; _i < coloredPixels && writePos < _spriteManager.SpriteManager.SPRITE_DATA_SIZE; _i++) {
                    this.m_pixels.addU8(inputFile.getU8());
                    this.m_pixels.addU8(inputFile.getU8());
                    this.m_pixels.addU8(inputFile.getU8());
                    this.m_pixels.addU8(useAlpha ? inputFile.getU8() : 0xFF);
                    writePos += 4;
                }
                read += 4 + channels * coloredPixels;
            }
            // fill remaining pixels with alpha
            while (writePos < _spriteManager.SpriteManager.SPRITE_DATA_SIZE) {
                this.m_pixels.addU8(0x00);
                this.m_pixels.addU8(0x00);
                this.m_pixels.addU8(0x00);
                this.m_pixels.addU8(0x00);
                writePos += 4;
            }
        }
    }, {
        key: "writeToSpr",
        value: function writeToSpr(outputFile, client) {
            outputFile.addU8(255);
            outputFile.addU8(0);
            outputFile.addU8(255);
            var pixelsSprData = this.getSprData(client);
            outputFile.addU16(pixelsSprData.size());
            for (var i = 0; i < pixelsSprData.size(); i++) {
                outputFile.addU8(pixelsSprData.getU8(i));
            }
        }
    }, {
        key: "getSprData",
        value: function getSprData(client) {
            var pixelsSprData = new _dataBuffer.DataBuffer();
            var useAlpha = client.getFeature(_const.GameFeature.GameSpritesAlphaChannel);
            var bytesPerPixel = useAlpha ? 4 : 3;
            var read = 0;
            var pixel = this.m_pixels.getRgbaPixel(read++);
            while (read < this.getPixelsCount()) {
                var transparentPixels = 0;
                var coloredPixels = [];
                while (pixel.isTransparent()) {
                    transparentPixels++;
                    if (read == this.getPixelsCount()) break;
                    pixel = this.m_pixels.getRgbaPixel(read++);
                }
                while (!pixel.isTransparent()) {
                    coloredPixels.push(pixel);
                    if (read == this.getPixelsCount()) break;
                    pixel = this.m_pixels.getRgbaPixel(read++);
                }
                pixelsSprData.addU16(transparentPixels);
                pixelsSprData.addU16(coloredPixels.length);
                var _iteratorNormalCompletion = true;
                var _didIteratorError = false;
                var _iteratorError = undefined;

                try {
                    for (var _iterator = coloredPixels[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                        var coloredPixel = _step.value;

                        pixelsSprData.addPixel(coloredPixel, bytesPerPixel);
                    }
                } catch (err) {
                    _didIteratorError = true;
                    _iteratorError = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion && _iterator.return) {
                            _iterator.return();
                        }
                    } finally {
                        if (_didIteratorError) {
                            throw _iteratorError;
                        }
                    }
                }
            }
            return pixelsSprData;
        }
    }]);

    return Sprite;
}();

/***/ }),

/***/ 20:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Color = exports.Color = function () {
    //Color() : m_r(1.0f), m_g(1.0f), m_b(1.0f), m_a(1.0f) { }
    //Color(uint32 rgba) { setRGBA(rgba); }
    function Color() {
        _classCallCheck(this, Color);

        if (arguments.length == 0) {
            this.m_r = 1;
            this.m_g = 1;
            this.m_b = 1;
            this.m_a = 1;
            return;
        } else if (arguments.length == 1) {
            if (typeof (arguments.length <= 0 ? undefined : arguments[0]) == 'number') {
                this.setRGBA(arguments.length <= 0 ? undefined : arguments[0]);
                return;
            }
        } else if (arguments.length == 3) {
            if (typeof (arguments.length <= 0 ? undefined : arguments[0]) == 'number' && typeof (arguments.length <= 1 ? undefined : arguments[1]) == 'number' && typeof (arguments.length <= 2 ? undefined : arguments[2]) == 'number') {
                var r = (arguments.length <= 0 ? undefined : arguments[0]) / 255;
                var g = (arguments.length <= 1 ? undefined : arguments[1]) / 255;
                var b = (arguments.length <= 2 ? undefined : arguments[2]) / 255;
                this.m_r = r;
                this.m_g = g;
                this.m_b = b;
                this.m_a = 1;
                return;
            }
        }
        throw new Error('Unhandled constructor');
    }

    _createClass(Color, [{
        key: 'equals',
        value: function equals(otherColor) {
            return this.m_r == otherColor.m_r && this.m_g == otherColor.m_g && this.m_b == otherColor.m_b && this.m_a == otherColor.m_a;
        }
    }, {
        key: 'clone',
        value: function clone() {
            var color = new Color();
            color.m_r = this.m_r;
            color.m_g = this.m_g;
            color.m_b = this.m_b;
            color.m_a = this.m_a;
            return color;
        }
    }, {
        key: 'a',
        value: function a() {
            return this.m_a * 255.0;
        }
    }, {
        key: 'b',
        value: function b() {
            return this.m_b * 255.0;
        }
    }, {
        key: 'g',
        value: function g() {
            return this.m_g * 255.0;
        }
    }, {
        key: 'r',
        value: function r() {
            return this.m_r * 255.0;
        }
    }, {
        key: 'aF',
        value: function aF() {
            return this.m_a;
        }
    }, {
        key: 'bF',
        value: function bF() {
            return this.m_b;
        }
    }, {
        key: 'gF',
        value: function gF() {
            return this.m_g;
        }
    }, {
        key: 'rF',
        value: function rF() {
            return this.m_r;
        }
    }, {
        key: 'rgba',
        value: function rgba() {
            return this.a() | this.b() << 8 | this.g() << 16 | this.r() << 24;
        }
    }, {
        key: 'setRGBA',
        value: function setRGBA(r) {
            var g = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : -1;
            var b = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : -1;
            var a = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 255;

            if (g == -1) {
                // r is rgba
                var rgba = r;
                this.setRGBA(rgba >> 0 & 0xff, rgba >> 8 & 0xff, rgba >> 16 & 0xff, rgba >> 24 & 0xff);
            } else {
                this.m_r = r / 255;
                this.m_g = g / 255;
                this.m_b = b / 255;
                this.m_a = a / 255;
            }
        }
    }], [{
        key: 'from8bit',
        value: function from8bit(color) {
            if (color >= 216 || color <= 0) return new Color(0, 0, 0);
            var r = parseInt((color / 36).toString()) % 6 * 51;
            var g = parseInt((color / 6).toString()) % 6 * 51;
            var b = color % 6 * 51;
            return new Color(r, g, b);
        }
    }]);

    return Color;
}();

Color.alpha = 0x00000000;
Color.white = 0xffffffff;
Color.red = 0xff0000ff;
Color.green = 0xff00ff00;
Color.blue = 0xffff0000;
Color.yellow = 0xff00ffff;

/***/ }),

/***/ 21:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Light = exports.Light = function Light() {
    var intensity = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var color = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 215;

    _classCallCheck(this, Light);

    this.intensity = intensity;
    this.color = color;
};

/***/ }),

/***/ 22:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.InputFile = undefined;

var _fileStream = __webpack_require__(23);

var _dataBuffer = __webpack_require__(8);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var InputFile = exports.InputFile = function (_FileStream) {
    _inherits(InputFile, _FileStream);

    function InputFile(msg) {
        _classCallCheck(this, InputFile);

        var _this = _possibleConstructorReturn(this, (InputFile.__proto__ || Object.getPrototypeOf(InputFile)).call(this));

        _this.data = new _dataBuffer.DataBuffer();
        _this.data.m_buffer = msg;
        _this.data.m_size = msg.byteLength;
        _this.data.m_capacity = msg.byteLength;
        _this.offset = 0;
        return _this;
    }

    return InputFile;
}(_fileStream.FileStream);

/***/ }),

/***/ 23:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FileStream = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _position = __webpack_require__(24);

var _binaryTree = __webpack_require__(25);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var FileStream = exports.FileStream = function () {
    function FileStream() {
        _classCallCheck(this, FileStream);
    }

    _createClass(FileStream, [{
        key: "getUint8Array",
        value: function getUint8Array() {
            return this.data.getUint8Array();
        }
    }, {
        key: "getU8",
        value: function getU8() {
            var v = this.data.getU8(this.offset);
            this.offset += 1;
            return v;
        }
    }, {
        key: "getU16",
        value: function getU16() {
            var v = this.data.getU16(this.offset);
            this.offset += 2;
            return v;
        }
    }, {
        key: "getU32",
        value: function getU32() {
            var v = this.data.getU32(this.offset);
            this.offset += 4;
            return v;
        }
    }, {
        key: "getU64",
        value: function getU64() {
            var v = this.data.getU32(this.offset) + this.data.getU32(this.offset) * 256 * 256 * 256 * 256;
            this.offset += 8;
            return v;
        }
    }, {
        key: "get8",
        value: function get8() {
            var v = this.data.get8(this.offset);
            this.offset += 1;
            return v;
        }
    }, {
        key: "get16",
        value: function get16() {
            var v = this.data.get16(this.offset);
            this.offset += 2;
            return v;
        }
    }, {
        key: "get32",
        value: function get32() {
            var v = this.data.get32(this.offset);
            this.offset += 4;
            return v;
        }
    }, {
        key: "getDouble",
        value: function getDouble() {
            var v = this.data.getDouble(this.offset);
            this.offset += 8;
            return v;
        }
    }, {
        key: "getString",
        value: function getString() {
            var v = this.data.getString(this.offset);
            this.offset += 2 + v.length;
            return v;
        }
    }, {
        key: "getPosition",
        value: function getPosition() {
            return new _position.Position(this.getU16(), this.getU16(), this.getU8());
        }
    }, {
        key: "getBytes",
        value: function getBytes(bytesCount) {
            var bytes = this.data.getBytes(this.offset, bytesCount);
            this.offset += bytesCount;
            return bytes;
        }
    }, {
        key: "getBinaryTree",
        value: function getBinaryTree() {
            var byte = this.getU8();
            if (byte != _binaryTree.BinaryTree.BINARYTREE_NODE_START) throw new Error("failed to read node start (getBinaryTree): " + byte);
            return new _binaryTree.BinaryTree(this);
        }
    }, {
        key: "peekU8",
        value: function peekU8() {
            return this.data.getU8(this.offset);
        }
    }, {
        key: "peekU16",
        value: function peekU16() {
            return this.data.getU16(this.offset);
        }
    }, {
        key: "peekU32",
        value: function peekU32() {
            return this.data.getU32(this.offset);
        }
    }, {
        key: "skipBytes",
        value: function skipBytes(bytesCount) {
            if (this.offset + bytesCount > this.data.size()) throw new Error("Invalid offset. Cannot read.");
            this.offset += bytesCount;
        }
    }, {
        key: "skip",
        value: function skip(bytesCount) {
            this.skipBytes(bytesCount);
        }
    }, {
        key: "getUnreadSize",
        value: function getUnreadSize() {
            return this.data.size() - this.offset;
        }
    }, {
        key: "tell",
        value: function tell() {
            return this.offset;
        }
    }, {
        key: "seek",
        value: function seek(offset) {
            this.offset = offset;
        }
    }]);

    return FileStream;
}();

/***/ }),

/***/ 24:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Position = exports.Position = function Position() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

    _classCallCheck(this, Position);

    this.x = x;
    this.y = y;
    this.z = z;
};

/***/ }),

/***/ 25:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BinaryTree = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _dataBuffer = __webpack_require__(8);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var BinaryTree = exports.BinaryTree = function () {
    function BinaryTree(m_fin) {
        _classCallCheck(this, BinaryTree);

        this.m_fin = m_fin;
        this.m_pos = 0xFFFFFFFF;
        this.m_startPos = 0;
        this.m_buffer = new _dataBuffer.DataBuffer();
        this.m_startPos = this.m_fin.tell();
    }

    _createClass(BinaryTree, [{
        key: "skipNodes",
        value: function skipNodes() {
            while (true) {
                var byte = this.m_fin.getU8();
                switch (byte) {
                    case BinaryTree.BINARYTREE_NODE_START:
                        {
                            this.skipNodes();
                            break;
                        }
                    case BinaryTree.BINARYTREE_NODE_END:
                        return;
                    case BinaryTree.BINARYTREE_ESCAPE_CHAR:
                        this.m_fin.getU8();
                        break;
                    default:
                        break;
                }
            }
        }
    }, {
        key: "unserialize",
        value: function unserialize() {
            if (this.m_pos != 0xFFFFFFFF) return;
            this.m_pos = 0;
            this.m_fin.seek(this.m_startPos);
            while (true) {
                var byte = this.m_fin.getU8();
                switch (byte) {
                    case BinaryTree.BINARYTREE_NODE_START:
                        {
                            this.skipNodes();
                            break;
                        }
                    case BinaryTree.BINARYTREE_NODE_END:
                        this.m_pos = 0;
                        // console.log(this.m_buffer);
                        return;
                    case BinaryTree.BINARYTREE_ESCAPE_CHAR:
                        this.m_buffer.addU8(this.m_fin.getU8());
                        break;
                    default:
                        this.m_buffer.addU8(byte);
                        break;
                }
            }
        }
    }, {
        key: "getChildren",
        value: function getChildren() {
            var children = [];
            this.m_fin.seek(this.m_startPos);
            while (true) {
                var byte = this.m_fin.getU8();
                switch (byte) {
                    case BinaryTree.BINARYTREE_NODE_START:
                        {
                            var node = new BinaryTree(this.m_fin);
                            children.push(node);
                            node.skipNodes();
                            break;
                        }
                    case BinaryTree.BINARYTREE_NODE_END:
                        return children;
                    case BinaryTree.BINARYTREE_ESCAPE_CHAR:
                        this.m_fin.getU8();
                        break;
                    default:
                        break;
                }
            }
        }
    }, {
        key: "seek",
        value: function seek(pos) {
            this.unserialize();
            if (pos > this.m_buffer.size()) throw new Error("BinaryTree: seek failed");
            this.m_pos = pos;
        }
    }, {
        key: "tell",
        value: function tell() {
            return this.m_pos;
        }
    }, {
        key: "skip",
        value: function skip(len) {
            this.unserialize();
            this.seek(this.tell() + len);
        }
    }, {
        key: "getU8",
        value: function getU8() {
            this.unserialize();
            if (this.m_pos + 1 > this.m_buffer.size()) throw new Error("BinaryTree: getU8 failed");
            var v = this.m_buffer.getU8(this.m_pos);
            this.m_pos += 1;
            return v;
        }
    }, {
        key: "getU16",
        value: function getU16() {
            return this.getU8() + this.getU8() * 256;
        }
    }, {
        key: "getU32",
        value: function getU32() {
            return this.getU16() + this.getU16() * 256 * 256;
        }
    }, {
        key: "getU64",
        value: function getU64() {
            return this.getU32() + this.getU32() * 256 * 256 * 256 * 256;
        }
    }, {
        key: "getString",
        value: function getString(len) {
            this.unserialize();
            if (len == 0) len = this.getU16();
            if (this.m_pos + len > this.m_buffer.size()) throw new Error("BinaryTree: getString failed: string length exceeded buffer size.");
            var text = '';
            for (var i = 0; i < len; i++) {
                text += String.fromCharCode(this.getU8());
            }
            return text;
        }
    }, {
        key: "canRead",
        value: function canRead() {
            this.unserialize();
            return this.m_pos < this.m_buffer.size();
        }
    }]);

    return BinaryTree;
}();

BinaryTree.BINARYTREE_ESCAPE_CHAR = 0xFD;
BinaryTree.BINARYTREE_NODE_START = 0xFE;
BinaryTree.BINARYTREE_NODE_END = 0xFF;

/***/ }),

/***/ 26:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var toInt = function toInt(int) {
    return parseInt(int.toString());
};
var sortObjectByKey = function sortObjectByKey(obj) {
    if ((typeof obj === "undefined" ? "undefined" : _typeof(obj)) !== "object" || obj === null) return obj;
    if (Array.isArray(obj)) return obj.map(function (e) {
        return sortObjectByKey(e);
    }).sort();
    return Object.keys(obj).sort().reduce(function (sorted, k) {
        sorted[k] = sortObjectByKey(obj[k]);
        return sorted;
    }, {});
};
exports.toInt = toInt;
exports.sortObjectByKey = sortObjectByKey;

/***/ }),

/***/ 4:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var log = function log() {
    ///  console.log.apply(this, v);
    //$('#status').text(v.join(','));
};
var error = function error() {
    for (var _len = arguments.length, v = Array(_len), _key = 0; _key < _len; _key++) {
        v[_key] = arguments[_key];
    }

    console.error.apply(this, v);
    //$('#status').text(v.join(','));
};

var Log = exports.Log = function () {
    function Log() {
        _classCallCheck(this, Log);
    }

    _createClass(Log, null, [{
        key: "log",
        value: function log() {
            ///  console.log.apply(this, v);
            //$('#status').text(v.join(','));
        }
    }, {
        key: "debug",
        value: function debug() {
            ///  console.log.apply(this, v);
            //$('#status').text(v.join(','));
        }
    }, {
        key: "error",
        value: function error() {
            for (var _len2 = arguments.length, v = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                v[_key2] = arguments[_key2];
            }

            console.error.apply(this, v);
            //$('#status').text(v.join(','));
        }
    }]);

    return Log;
}();

exports.log = log;
exports.error = error;

/***/ }),

/***/ 41:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Client = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _const = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Client = exports.Client = function () {
    function Client() {
        _classCallCheck(this, Client);

        this.m_clientVersion = 0;
        this.m_features = [];
    }

    _createClass(Client, [{
        key: "getClientVersion",
        value: function getClientVersion() {
            return this.m_clientVersion;
        }
    }, {
        key: "setClientVersion",
        value: function setClientVersion(version) {
            this.m_clientVersion = version;
            this.updateFeatures(version);
        }
    }, {
        key: "enableFeature",
        value: function enableFeature(feature) {
            this.m_features[feature] = true;
        }
    }, {
        key: "disableFeature",
        value: function disableFeature(feature) {
            this.m_features[feature] = false;
        }
    }, {
        key: "getFeature",
        value: function getFeature(feature) {
            return this.m_features[feature] == true;
        }
    }, {
        key: "updateFeatures",
        value: function updateFeatures(version) {
            this.m_features = [];
            this.enableFeature(_const.GameFeature.GameFormatCreatureName);
            if (version >= 770) {
                this.enableFeature(_const.GameFeature.GameLooktypeU16);
                this.enableFeature(_const.GameFeature.GameMessageStatements);
                this.enableFeature(_const.GameFeature.GameLoginPacketEncryption);
            }
            if (version >= 780) {
                this.enableFeature(_const.GameFeature.GamePlayerAddons);
                this.enableFeature(_const.GameFeature.GamePlayerStamina);
                this.enableFeature(_const.GameFeature.GameNewFluids);
                this.enableFeature(_const.GameFeature.GameMessageLevel);
                this.enableFeature(_const.GameFeature.GamePlayerStateU16);
                this.enableFeature(_const.GameFeature.GameNewOutfitProtocol);
            }
            if (version >= 790) {
                this.enableFeature(_const.GameFeature.GameWritableDate);
            }
            if (version >= 840) {
                this.enableFeature(_const.GameFeature.GameProtocolChecksum);
                this.enableFeature(_const.GameFeature.GameAccountNames);
                this.enableFeature(_const.GameFeature.GameDoubleFreeCapacity);
            }
            if (version >= 841) {
                this.enableFeature(_const.GameFeature.GameChallengeOnLogin);
                this.enableFeature(_const.GameFeature.GameMessageSizeCheck);
            }
            if (version >= 854) {
                this.enableFeature(_const.GameFeature.GameCreatureEmblems);
            }
            if (version >= 860) {
                this.enableFeature(_const.GameFeature.GameAttackSeq);
            }
            if (version >= 862) {
                this.enableFeature(_const.GameFeature.GamePenalityOnDeath);
            }
            if (version >= 870) {
                this.enableFeature(_const.GameFeature.GameDoubleExperience);
                this.enableFeature(_const.GameFeature.GamePlayerMounts);
                this.enableFeature(_const.GameFeature.GameSpellList);
            }
            if (version >= 910) {
                this.enableFeature(_const.GameFeature.GameNameOnNpcTrade);
                this.enableFeature(_const.GameFeature.GameTotalCapacity);
                this.enableFeature(_const.GameFeature.GameSkillsBase);
                this.enableFeature(_const.GameFeature.GamePlayerRegenerationTime);
                this.enableFeature(_const.GameFeature.GameChannelPlayerList);
                this.enableFeature(_const.GameFeature.GameEnvironmentEffect);
                this.enableFeature(_const.GameFeature.GameItemAnimationPhase);
            }
            if (version >= 940) {
                this.enableFeature(_const.GameFeature.GamePlayerMarket);
            }
            if (version >= 953) {
                this.enableFeature(_const.GameFeature.GamePurseSlot);
                this.enableFeature(_const.GameFeature.GameClientPing);
            }
            if (version >= 960) {
                this.enableFeature(_const.GameFeature.GameSpritesU32);
                this.enableFeature(_const.GameFeature.GameOfflineTrainingTime);
            }
            if (version >= 963) {
                this.enableFeature(_const.GameFeature.GameAdditionalVipInfo);
            }
            if (version >= 980) {
                this.enableFeature(_const.GameFeature.GamePreviewState);
                this.enableFeature(_const.GameFeature.GameClientVersion);
            }
            if (version >= 981) {
                this.enableFeature(_const.GameFeature.GameLoginPending);
                this.enableFeature(_const.GameFeature.GameNewSpeedLaw);
            }
            if (version >= 984) {
                this.enableFeature(_const.GameFeature.GameContainerPagination);
                this.enableFeature(_const.GameFeature.GameBrowseField);
            }
            if (version >= 1000) {
                this.enableFeature(_const.GameFeature.GameThingMarks);
                this.enableFeature(_const.GameFeature.GamePVPMode);
            }
            if (version >= 1035) {
                this.enableFeature(_const.GameFeature.GameDoubleSkills);
                this.enableFeature(_const.GameFeature.GameBaseSkillU16);
            }
            if (version >= 1036) {
                this.enableFeature(_const.GameFeature.GameCreatureIcons);
                this.enableFeature(_const.GameFeature.GameHideNpcNames);
            }
            if (version >= 1038) {
                this.enableFeature(_const.GameFeature.GamePremiumExpiration);
            }
            if (version >= 1050) {
                this.enableFeature(_const.GameFeature.GameEnhancedAnimations);
            }
            if (version >= 1053) {
                this.enableFeature(_const.GameFeature.GameUnjustifiedPoints);
            }
            if (version >= 1054) {
                this.enableFeature(_const.GameFeature.GameExperienceBonus);
            }
            if (version >= 1055) {
                this.enableFeature(_const.GameFeature.GameDeathType);
            }
            if (version >= 1057) {
                this.enableFeature(_const.GameFeature.GameIdleAnimations);
            }
            if (version >= 1061) {
                this.enableFeature(_const.GameFeature.GameOGLInformation);
            }
            if (version >= 1071) {
                this.enableFeature(_const.GameFeature.GameContentRevision);
            }
            if (version >= 1072) {
                this.enableFeature(_const.GameFeature.GameAuthenticator);
            }
            if (version >= 1074) {
                this.enableFeature(_const.GameFeature.GameSessionKey);
            }
            if (version >= 1080) {
                this.enableFeature(_const.GameFeature.GameIngameStore);
            }
            if (version >= 1092) {
                this.enableFeature(_const.GameFeature.GameIngameStoreServiceType);
            }
            if (version >= 1093) {
                this.enableFeature(_const.GameFeature.GameIngameStoreHighlights);
            }
            if (version >= 1094) {
                this.enableFeature(_const.GameFeature.GameAdditionalSkills);
            }
        }
    }]);

    return Client;
}();

/***/ }),

/***/ 42:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DatManager = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _datThingType = __webpack_require__(43);

var _const = __webpack_require__(1);

var _log = __webpack_require__(4);

var _resources = __webpack_require__(13);

var _outputFile = __webpack_require__(14);

var _helpers = __webpack_require__(26);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

var DatManager = exports.DatManager = function () {
    function DatManager(m_client) {
        _classCallCheck(this, DatManager);

        this.m_client = m_client;
        this.m_thingTypes = [];
        this.m_datSignature = 0;
        this.m_contentRevision = 0;
        for (var i = _const.DatThingCategory.ThingCategoryItem; i < _const.DatThingCategory.ThingLastCategory; ++i) {
            this.m_thingTypes[i] = [];
        }
    }

    _createClass(DatManager, [{
        key: "getThingType",
        value: function getThingType(id, category) {
            if (category >= _const.DatThingCategory.ThingLastCategory || id >= this.m_thingTypes[category].length) {
                _log.Log.error("invalid thing type client id %d in category %d", id, category);
                return DatManager.m_nullThingType;
            }
            return this.m_thingTypes[category][id];
        }
    }, {
        key: "getThingTypes",
        value: function getThingTypes() {
            return this.m_thingTypes;
        }
    }, {
        key: "getCategory",
        value: function getCategory(category) {
            return this.m_thingTypes[category];
        }
    }, {
        key: "getItem",
        value: function getItem(id) {
            return this.getThingType(id, _const.DatThingCategory.ThingCategoryItem);
        }
    }, {
        key: "getOutfit",
        value: function getOutfit(id) {
            return this.getThingType(id, _const.DatThingCategory.ThingCategoryCreature);
        }
    }, {
        key: "getEffect",
        value: function getEffect(id) {
            return this.getThingType(id, _const.DatThingCategory.ThingCategoryEffect);
        }
    }, {
        key: "getMissile",
        value: function getMissile(id) {
            return this.getThingType(id, _const.DatThingCategory.ThingCategoryMissile);
        }
    }, {
        key: "isValidDatId",
        value: function isValidDatId(id, category) {
            return true;
        }
    }, {
        key: "getNullThingType",
        value: function getNullThingType() {
            return DatManager.m_nullThingType;
        }
    }, {
        key: "getDatSignature",
        value: function getDatSignature() {
            throw this.m_datSignature;
        }
    }, {
        key: "getContentRevision",
        value: function getContentRevision() {
            throw this.m_contentRevision;
        }
    }, {
        key: "loadDatFromUrl",
        value: function loadDatFromUrl(url) {
            return __awaiter(this, void 0, void 0, /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
                var fin;
                return regeneratorRuntime.wrap(function _callee$(_context) {
                    while (1) {
                        switch (_context.prev = _context.next) {
                            case 0:
                                _context.next = 2;
                                return _resources.g_resources.openUrl(url);

                            case 2:
                                fin = _context.sent;
                                return _context.abrupt("return", this.loadDat(fin));

                            case 4:
                            case "end":
                                return _context.stop();
                        }
                    }
                }, _callee, this);
            }));
        }
    }, {
        key: "loadDat",
        value: function loadDat(fin) {
            this.m_datSignature = 0;
            this.m_contentRevision = 0;
            try {
                this.m_datSignature = fin.getU32();
                this.m_contentRevision = this.m_datSignature & 0xFFFF;
                for (var category = _const.DatThingCategory.ThingCategoryItem; category < _const.DatThingCategory.ThingLastCategory; ++category) {
                    var count = fin.getU16() + 1;
                    this.m_thingTypes[category] = [];
                    for (var thingCount = 0; thingCount < count; ++thingCount) {
                        this.m_thingTypes[category][thingCount] = DatManager.m_nullThingType;
                    }
                }
                var clientTranslationArray = this.getClientTranslationArray();
                for (var _category = 0; _category < _const.DatThingCategory.ThingLastCategory; ++_category) {
                    var firstId = 1;
                    if (_category == _const.DatThingCategory.ThingCategoryItem) firstId = 100;
                    for (var id = firstId; id < this.m_thingTypes[_category].length; ++id) {
                        var type = new _datThingType.DatThingType();
                        type.unserialize(id, _category, fin, this.m_client, clientTranslationArray);
                        this.m_thingTypes[_category][id] = type;
                    }
                }
                return true;
            } catch (e) {
                _log.Log.error("Failed to read dat: %s'", e);
                return false;
            }
        }
    }, {
        key: "saveDat",
        value: function saveDat() {
            var fin = new _outputFile.OutputFile();
            fin.addU32(this.m_datSignature);
            for (var category = 0; category < _const.DatThingCategory.ThingLastCategory; ++category) {
                fin.addU16(this.m_thingTypes[category].length - 1);
            }
            var clientTranslationArray = this.getClientTranslationArray();
            for (var _category2 = 0; _category2 < _const.DatThingCategory.ThingLastCategory; ++_category2) {
                var firstId = 1;
                if (_category2 == _const.DatThingCategory.ThingCategoryItem) firstId = 100;
                for (var id = firstId; id < this.m_thingTypes[_category2].length; ++id) {
                    this.m_thingTypes[_category2][id].serialize(fin, _category2, this.m_client, clientTranslationArray);
                }
            }
            return fin;
        }
    }, {
        key: "getClientTranslationArray",
        value: function getClientTranslationArray() {
            var clientAttributesTranslator = {};
            for (var thingAttr = 0; thingAttr < _const.DatThingAttr.ThingLastAttr; ++thingAttr) {
                if (_const.DatThingAttr[thingAttr] === undefined) {
                    continue;
                }
                var clientDatAttribute = thingAttr;
                if (this.m_client.getClientVersion() >= 1000) {
                    /* In 10.10+ all attributes from 16 and up were
                     * incremented by 1 to make space for 16 as
                     * "No Movement Animation" flag.
                     */
                    if (thingAttr == _const.DatThingAttr.ThingAttrNoMoveAnimation) clientDatAttribute = 16;else if (thingAttr >= _const.DatThingAttr.ThingAttrPickupable) clientDatAttribute += 1;
                } else if (this.m_client.getClientVersion() >= 860) {
                    /* Default attribute values follow
                     * the format of 8.6-9.86.
                     * Therefore no changes here.
                     */
                } else if (this.m_client.getClientVersion() >= 780) {
                    /* In 7.80-8.54 all attributes from 8 and higher were
                     * incremented by 1 to make space for 8 as
                     * "Item Charges" flag.
                     */
                    if (thingAttr == _const.DatThingAttr.ThingAttrChargeable) clientDatAttribute = _const.DatThingAttr.ThingAttrWritable;else if (thingAttr >= _const.DatThingAttr.ThingAttrWritable) clientDatAttribute += 1;
                } else if (this.m_client.getClientVersion() >= 755) {
                    /* In 7.55-7.72 attributes 23 is "Floor Change". */
                    if (thingAttr == _const.DatThingAttr.ThingAttrFloorChange) clientDatAttribute = 23;
                } else if (this.m_client.getClientVersion() >= 740) {
                    /* In 7.4-7.5 attribute "Ground Border" did not exist
                     * attributes 1-15 have to be adjusted.
                     * Several other changes in the format.
                     */
                    if (thingAttr > 1 && thingAttr <= 16) thingAttr -= 1;else if (thingAttr == _const.DatThingAttr.ThingAttrLight) thingAttr = 16;else if (thingAttr == _const.DatThingAttr.ThingAttrFloorChange) thingAttr = 17;else if (thingAttr == _const.DatThingAttr.ThingAttrFullGround) thingAttr = 18;else if (thingAttr == _const.DatThingAttr.ThingAttrElevation) thingAttr = 19;else if (thingAttr == _const.DatThingAttr.ThingAttrDisplacement) thingAttr = 20;else if (thingAttr == _const.DatThingAttr.ThingAttrMinimapColor) thingAttr = 22;else if (thingAttr == _const.DatThingAttr.ThingAttrRotateable) thingAttr = 23;else if (thingAttr == _const.DatThingAttr.ThingAttrLyingCorpse) thingAttr = 24;else if (thingAttr == _const.DatThingAttr.ThingAttrHangable) thingAttr = 25;else if (thingAttr == _const.DatThingAttr.ThingAttrHookSouth) thingAttr = 26;else if (thingAttr == _const.DatThingAttr.ThingAttrHookEast) thingAttr = 27;else if (thingAttr == _const.DatThingAttr.ThingAttrAnimateAlways) thingAttr = 28;
                    /* "Multi Use" and "Force Use" are swapped */
                    if (thingAttr == _const.DatThingAttr.ThingAttrMultiUse) clientDatAttribute = _const.DatThingAttr.ThingAttrForceUse;else if (thingAttr == _const.DatThingAttr.ThingAttrForceUse) clientDatAttribute = _const.DatThingAttr.ThingAttrMultiUse;
                }
                clientAttributesTranslator[clientDatAttribute] = thingAttr;
            }
            return (0, _helpers.sortObjectByKey)(clientAttributesTranslator);
        }
    }]);

    return DatManager;
}();

DatManager.m_nullThingType = new _datThingType.DatThingType();

/***/ }),

/***/ 43:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DatThingType = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _const = __webpack_require__(1);

var _log = __webpack_require__(4);

var _animator = __webpack_require__(44);

var _color = __webpack_require__(20);

var _datThingTypeAttributes = __webpack_require__(45);

var _size = __webpack_require__(7);

var _point = __webpack_require__(11);

var _marketData = __webpack_require__(46);

var _light = __webpack_require__(21);

var _frameGroup = __webpack_require__(47);

var _bonesData = __webpack_require__(48);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var DatThingType = exports.DatThingType = function () {
    function DatThingType() {
        _classCallCheck(this, DatThingType);

        this.m_id = 0;
        this.m_null = true;
        this.m_attribs = new _datThingTypeAttributes.DatThingTypeAttributes();
        this.m_displacement = new _point.Point();
        this.m_elevation = 0;
        this.m_frameGroups = [];
    }

    _createClass(DatThingType, [{
        key: "serialize",
        value: function serialize(fin, category, client, clientAttributeTranslator) {
            for (var clientAttrString in clientAttributeTranslator) {
                if (clientAttributeTranslator.hasOwnProperty(clientAttrString)) {
                    var clientDatAttr = parseInt(clientAttrString);
                    var thingAttr = parseInt(clientAttributeTranslator[clientDatAttr]);
                    if (!this.hasAttr(thingAttr)) continue;
                    fin.addU8(clientDatAttr);
                    switch (thingAttr) {
                        case _const.DatThingAttr.ThingAttrDisplacement:
                            {
                                if (client.getClientVersion() >= 755) {
                                    fin.addU16(this.m_displacement.x);
                                    fin.addU16(this.m_displacement.y);
                                }
                                break;
                            }
                        case _const.DatThingAttr.ThingAttrLight:
                            {
                                var light = this.m_attribs.get(thingAttr);
                                fin.addU16(light.intensity);
                                fin.addU16(light.color);
                                break;
                            }
                        case _const.DatThingAttr.ThingAttrMarket:
                            {
                                var market = this.m_attribs.get(thingAttr);
                                fin.addU16(market.category);
                                fin.addU16(market.tradeAs);
                                fin.addU16(market.showAs);
                                fin.addString(market.name);
                                fin.addU16(market.restrictVocation);
                                fin.addU16(market.requiredLevel);
                                break;
                            }
                        case _const.DatThingAttr.ThingAttrBones:
                            {
                                // 'Oen44' OTCv8 extra parameter for Wings, 8x U16
                                var bones = this.m_attribs.get(thingAttr);
                                fin.addU16(bones.north_x);
                                fin.addU16(bones.north_y);
                                fin.addU16(bones.south_x);
                                fin.addU16(bones.south_y);
                                fin.addU16(bones.east_x);
                                fin.addU16(bones.east_y);
                                fin.addU16(bones.west_x);
                                fin.addU16(bones.west_y);
                                break;
                            }
                        case _const.DatThingAttr.ThingAttrUsable:
                        case _const.DatThingAttr.ThingAttrElevation:
                        case _const.DatThingAttr.ThingAttrGround:
                        case _const.DatThingAttr.ThingAttrWritable:
                        case _const.DatThingAttr.ThingAttrWritableOnce:
                        case _const.DatThingAttr.ThingAttrMinimapColor:
                        case _const.DatThingAttr.ThingAttrCloth:
                        case _const.DatThingAttr.ThingAttrLensHelp:
                            fin.addU16(this.m_attribs.get(thingAttr));
                            break;
                        default:
                            break;
                    }
                }
            }
            fin.addU8(_const.DatThingAttr.ThingLastAttr);
            var hasFrameGroups = category == _const.DatThingCategory.ThingCategoryCreature && client.getFeature(_const.GameFeature.GameIdleAnimations);
            if (hasFrameGroups) fin.addU8(this.m_frameGroups.length);
            for (var frameGroupType in this.m_frameGroups) {
                if (hasFrameGroups) fin.addU8(Number(frameGroupType));
                var frameGroup = this.m_frameGroups[frameGroupType];
                fin.addU8(frameGroup.m_size.width());
                fin.addU8(frameGroup.m_size.height());
                if (frameGroup.m_size.width() > 1 || frameGroup.m_size.height() > 1) fin.addU8(frameGroup.m_realSize);
                fin.addU8(frameGroup.m_layers);
                fin.addU8(frameGroup.m_numPatternX);
                fin.addU8(frameGroup.m_numPatternY);
                if (client.getClientVersion() >= 755) fin.addU8(frameGroup.m_numPatternZ);
                fin.addU8(frameGroup.m_animationPhases);
                if (client.getFeature(_const.GameFeature.GameEnhancedAnimations)) {
                    if (frameGroup.m_animationPhases > 1 && frameGroup.m_animator != null) {
                        frameGroup.m_animator.serialize(fin);
                    }
                }
                for (var i2 = 0; i2 < frameGroup.m_spritesIndex.length; i2++) {
                    if (client.getFeature(_const.GameFeature.GameSpritesU32)) fin.addU32(frameGroup.m_spritesIndex[i2]);else fin.addU16(frameGroup.m_spritesIndex[i2]);
                }
            }
        }
    }, {
        key: "unserialize",
        value: function unserialize(clientId, category, fin, client, clientTranslationArray) {
            this.m_null = false;
            this.m_id = clientId;
            this.m_category = category;
            var count = 0;
            var attr = -1;
            var done = false;
            for (var i = 0; i < _const.DatThingAttr.ThingLastAttr; ++i) {
                count++;
                attr = fin.getU8();
                if (attr == _const.DatThingAttr.ThingLastAttr) {
                    done = true;
                    break;
                }
                attr = clientTranslationArray[attr];
                switch (attr) {
                    case _const.DatThingAttr.ThingAttrDisplacement:
                        {
                            this.m_displacement = new _point.Point(0, 0);
                            if (client.getClientVersion() >= 755) {
                                this.m_displacement.x = fin.getU16();
                                this.m_displacement.y = fin.getU16();
                            } else {
                                this.m_displacement.x = 8;
                                this.m_displacement.y = 8;
                            }
                            this.m_attribs.set(attr, true);
                            break;
                        }
                    case _const.DatThingAttr.ThingAttrLight:
                        {
                            var light = new _light.Light();
                            light.intensity = fin.getU16();
                            light.color = fin.getU16();
                            this.m_attribs.set(attr, light);
                            break;
                        }
                    case _const.DatThingAttr.ThingAttrMarket:
                        {
                            var market = new _marketData.MarketData();
                            market.category = fin.getU16();
                            market.tradeAs = fin.getU16();
                            market.showAs = fin.getU16();
                            market.name = fin.getString();
                            market.restrictVocation = fin.getU16();
                            market.requiredLevel = fin.getU16();
                            this.m_attribs.set(attr, market);
                            break;
                        }
                    case _const.DatThingAttr.ThingAttrBones:
                        {
                            // 'Oen44' OTCv8 extra parameter for Wings, 8x U16
                            var bones = new _bonesData.BonesData();
                            bones.north_x = fin.getU16();
                            bones.north_y = fin.getU16();
                            bones.south_x = fin.getU16();
                            bones.south_y = fin.getU16();
                            bones.east_x = fin.getU16();
                            bones.east_y = fin.getU16();
                            bones.west_x = fin.getU16();
                            bones.west_y = fin.getU16();
                            this.m_attribs.set(attr, bones);
                            break;
                        }
                    case _const.DatThingAttr.ThingAttrElevation:
                        {
                            this.m_elevation = fin.getU16();
                            this.m_attribs.set(attr, this.m_elevation);
                            break;
                        }
                    case _const.DatThingAttr.ThingAttrUsable:
                    case _const.DatThingAttr.ThingAttrGround:
                    case _const.DatThingAttr.ThingAttrWritable:
                    case _const.DatThingAttr.ThingAttrWritableOnce:
                    case _const.DatThingAttr.ThingAttrMinimapColor:
                    case _const.DatThingAttr.ThingAttrCloth:
                    case _const.DatThingAttr.ThingAttrLensHelp:
                        this.m_attribs.set(attr, fin.getU16());
                        break;
                    default:
                        this.m_attribs.set(attr, true);
                        break;
                }
            }
            if (!done) (0, _log.error)("corrupt data (id: %d, category: %d, count: %d, lastAttr: %d)", this.m_id, this.m_category, count, attr);
            var hasFrameGroups = category == _const.DatThingCategory.ThingCategoryCreature && client.getFeature(_const.GameFeature.GameIdleAnimations);
            var groupCount = hasFrameGroups ? fin.getU8() : 1;
            for (var _i = 0; _i < groupCount; ++_i) {
                var frameGroupType = category == _const.DatThingCategory.ThingCategoryCreature ? _const.FrameGroupType.FrameGroupMoving : _const.FrameGroupType.FrameGroupIdle;
                if (hasFrameGroups) frameGroupType = fin.getU8();
                var frameGroup = new _frameGroup.FrameGroup();
                var width = fin.getU8();
                var height = fin.getU8();
                frameGroup.m_size = new _size.Size(width, height);
                if (width > 1 || height > 1) {
                    frameGroup.m_realSize = fin.getU8();
                    frameGroup.m_exactSize = Math.min(frameGroup.m_realSize, Math.max(width * 32, height * 32));
                } else frameGroup.m_exactSize = 32;
                frameGroup.m_layers = fin.getU8();
                frameGroup.m_numPatternX = fin.getU8();
                frameGroup.m_numPatternY = fin.getU8();
                if (client.getClientVersion() >= 755) frameGroup.m_numPatternZ = fin.getU8();else frameGroup.m_numPatternZ = 1;
                var groupAnimationsPhases = fin.getU8();
                frameGroup.m_animationPhases = groupAnimationsPhases;
                if (groupAnimationsPhases > 1 && client.getFeature(_const.GameFeature.GameEnhancedAnimations)) {
                    frameGroup.m_animator = new _animator.Animator();
                    frameGroup.m_animator.unserialize(groupAnimationsPhases, fin);
                }
                var totalSprites = frameGroup.m_size.area() * frameGroup.m_layers * frameGroup.m_numPatternX * frameGroup.m_numPatternY * frameGroup.m_numPatternZ * groupAnimationsPhases;
                if (totalSprites > 4096) (0, _log.error)("a thing type has more than 4096 sprites", totalSprites, frameGroup.m_size.area(), frameGroup.m_layers, frameGroup.m_numPatternX, frameGroup.m_numPatternY, frameGroup.m_numPatternZ, groupAnimationsPhases);
                frameGroup.m_spritesIndex = [];
                for (var _i2 = 0; _i2 < totalSprites; _i2++) {
                    frameGroup.m_spritesIndex[_i2] = client.getFeature(_const.GameFeature.GameSpritesU32) ? fin.getU32() : fin.getU16();
                }
                //console.log('spr', this.m_spritesIndex);
                this.m_frameGroups[frameGroupType] = frameGroup;
            }
        }
    }, {
        key: "getId",
        value: function getId() {
            return this.m_id;
        }
    }, {
        key: "getCategory",
        value: function getCategory() {
            return this.m_category;
        }
    }, {
        key: "isNull",
        value: function isNull() {
            return this.m_null;
        }
    }, {
        key: "hasAttr",
        value: function hasAttr(attr) {
            return this.m_attribs.has(attr);
        }
    }, {
        key: "getDisplacement",
        value: function getDisplacement() {
            return this.m_displacement;
        }
    }, {
        key: "getDisplacementX",
        value: function getDisplacementX() {
            return this.getDisplacement().x;
        }
    }, {
        key: "getDisplacementY",
        value: function getDisplacementY() {
            return this.getDisplacement().y;
        }
    }, {
        key: "getElevation",
        value: function getElevation() {
            return this.m_elevation;
        }
    }, {
        key: "getFrameGroups",
        value: function getFrameGroups() {
            return this.m_frameGroups;
        }
    }, {
        key: "getFrameGroup",
        value: function getFrameGroup(frameGroupType) {
            return this.m_frameGroups[frameGroupType];
        }
    }, {
        key: "getGroundSpeed",
        value: function getGroundSpeed() {
            return this.m_attribs.get(_const.DatThingAttr.ThingAttrGround);
        }
    }, {
        key: "getMaxTextLength",
        value: function getMaxTextLength() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrWritableOnce) ? this.m_attribs.get(_const.DatThingAttr.ThingAttrWritableOnce) : this.m_attribs.get(_const.DatThingAttr.ThingAttrWritable);
        }
    }, {
        key: "getLight",
        value: function getLight() {
            return this.m_attribs.get(_const.DatThingAttr.ThingAttrLight);
        }
    }, {
        key: "getMinimapColor",
        value: function getMinimapColor() {
            return this.m_attribs.get(_const.DatThingAttr.ThingAttrMinimapColor);
        }
    }, {
        key: "getLensHelp",
        value: function getLensHelp() {
            return this.m_attribs.get(_const.DatThingAttr.ThingAttrLensHelp);
        }
    }, {
        key: "getClothSlot",
        value: function getClothSlot() {
            return this.m_attribs.get(_const.DatThingAttr.ThingAttrCloth);
        }
    }, {
        key: "getMarketData",
        value: function getMarketData() {
            return this.m_attribs.get(_const.DatThingAttr.ThingAttrMarket);
        }
    }, {
        key: "getBones",
        value: function getBones() {
            return this.m_attribs.get(_const.DatThingAttr.ThingAttrBones);
        }
    }, {
        key: "isGround",
        value: function isGround() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrGround);
        }
    }, {
        key: "isGroundBorder",
        value: function isGroundBorder() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrGroundBorder);
        }
    }, {
        key: "isOnBottom",
        value: function isOnBottom() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrOnBottom);
        }
    }, {
        key: "isOnTop",
        value: function isOnTop() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrOnTop);
        }
    }, {
        key: "isContainer",
        value: function isContainer() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrContainer);
        }
    }, {
        key: "isStackable",
        value: function isStackable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrStackable);
        }
    }, {
        key: "isForceUse",
        value: function isForceUse() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrForceUse);
        }
    }, {
        key: "isMultiUse",
        value: function isMultiUse() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrMultiUse);
        }
    }, {
        key: "isWritable",
        value: function isWritable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrWritable);
        }
    }, {
        key: "isChargeable",
        value: function isChargeable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrChargeable);
        }
    }, {
        key: "isWritableOnce",
        value: function isWritableOnce() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrWritableOnce);
        }
    }, {
        key: "isFluidContainer",
        value: function isFluidContainer() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrFluidContainer);
        }
    }, {
        key: "isSplash",
        value: function isSplash() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrSplash);
        }
    }, {
        key: "isNotWalkable",
        value: function isNotWalkable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrNotWalkable);
        }
    }, {
        key: "isNotMoveable",
        value: function isNotMoveable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrNotMoveable);
        }
    }, {
        key: "blockProjectile",
        value: function blockProjectile() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrBlockProjectile);
        }
    }, {
        key: "isNotPathable",
        value: function isNotPathable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrNotPathable);
        }
    }, {
        key: "isPickupable",
        value: function isPickupable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrPickupable);
        }
    }, {
        key: "isHangable",
        value: function isHangable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrHangable);
        }
    }, {
        key: "isHookSouth",
        value: function isHookSouth() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrHookSouth);
        }
    }, {
        key: "isHookEast",
        value: function isHookEast() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrHookEast);
        }
    }, {
        key: "isRotateable",
        value: function isRotateable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrRotateable);
        }
    }, {
        key: "hasLight",
        value: function hasLight() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrLight);
        }
    }, {
        key: "isDontHide",
        value: function isDontHide() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrDontHide);
        }
    }, {
        key: "isTranslucent",
        value: function isTranslucent() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrTranslucent);
        }
    }, {
        key: "hasDisplacement",
        value: function hasDisplacement() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrDisplacement);
        }
    }, {
        key: "hasElevation",
        value: function hasElevation() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrElevation);
        }
    }, {
        key: "isLyingCorpse",
        value: function isLyingCorpse() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrLyingCorpse);
        }
    }, {
        key: "isAnimateAlways",
        value: function isAnimateAlways() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrAnimateAlways);
        }
    }, {
        key: "hasMiniMapColor",
        value: function hasMiniMapColor() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrMinimapColor);
        }
    }, {
        key: "hasLensHelp",
        value: function hasLensHelp() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrLensHelp);
        }
    }, {
        key: "hasBones",
        value: function hasBones() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrBones);
        }
    }, {
        key: "isFullGround",
        value: function isFullGround() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrFullGround);
        }
    }, {
        key: "isIgnoreLook",
        value: function isIgnoreLook() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrLook);
        }
    }, {
        key: "isCloth",
        value: function isCloth() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrCloth);
        }
    }, {
        key: "isMarketable",
        value: function isMarketable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrMarket);
        }
    }, {
        key: "isUsable",
        value: function isUsable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrUsable);
        }
    }, {
        key: "isWrapable",
        value: function isWrapable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrWrapable);
        }
    }, {
        key: "isUnwrapable",
        value: function isUnwrapable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrUnwrapable);
        }
    }, {
        key: "isTopEffect",
        value: function isTopEffect() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrTopEffect);
        }
    }, {
        key: "isNotPreWalkable",
        value: function isNotPreWalkable() {
            return this.m_attribs.has(_const.DatThingAttr.ThingAttrNotPreWalkable);
        }
    }, {
        key: "setPathable",
        value: function setPathable(v) {
            if (v == true) this.m_attribs.remove(_const.DatThingAttr.ThingAttrNotPathable);else this.m_attribs.set(_const.DatThingAttr.ThingAttrNotPathable, true);
        }
    }, {
        key: "getBestTextureDimension",
        value: function getBestTextureDimension(w, h, count) {
            var MAX = 32;
            var k = 1;
            while (k < w) {
                k <<= 1;
            }w = k;
            k = 1;
            while (k < h) {
                k <<= 1;
            }h = k;
            var numSprites = w * h * count;
            /*
            assert(numSprites <= MAX*MAX);
            assert(w <= MAX);
            assert(h <= MAX);
            */
            var bestDimension = new _size.Size(MAX, MAX);
            for (var i = w; i <= MAX; i <<= 1) {
                for (var j = h; j <= MAX; j <<= 1) {
                    var candidateDimension = new _size.Size(i, j);
                    if (candidateDimension.area() < numSprites) continue;
                    if (candidateDimension.area() < bestDimension.area() || candidateDimension.area() == bestDimension.area() && candidateDimension.width() + candidateDimension.height() < bestDimension.width() + bestDimension.height()) bestDimension = candidateDimension;
                }
            }
            return bestDimension;
        }
    }]);

    return DatThingType;
}();

DatThingType.maskColors = [_color.Color.red, _color.Color.green, _color.Color.blue, _color.Color.yellow];

/***/ }),

/***/ 44:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Animator = exports.Animator = function () {
    function Animator() {
        _classCallCheck(this, Animator);

        this.m_animationPhases = 0;
        this.m_startPhase = 0;
        this.m_loopCount = 0;
        this.m_async = false;
        this.m_phaseDurations = [];
    }

    _createClass(Animator, [{
        key: "unserialize",
        value: function unserialize(animationPhases, fin) {
            this.m_animationPhases = animationPhases;
            this.m_async = fin.getU8() == 0;
            this.m_loopCount = fin.get32();
            this.m_startPhase = fin.get8();
            for (var i = 0; i < this.m_animationPhases; ++i) {
                var minimum = fin.getU32();
                var maximum = fin.getU32();
                this.m_phaseDurations.push([minimum, maximum]);
            }
        }
    }, {
        key: "serialize",
        value: function serialize(fin) {
            fin.addU8(this.m_async ? 0 : 1);
            fin.add32(this.m_loopCount);
            fin.add8(this.m_startPhase);
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = this.m_phaseDurations[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var phase = _step.value;

                    fin.addU32(phase[0]);
                    fin.addU32(phase[1]);
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }
        }
    }]);

    return Animator;
}();

/***/ }),

/***/ 45:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var DatThingTypeAttributes = exports.DatThingTypeAttributes = function () {
    function DatThingTypeAttributes() {
        _classCallCheck(this, DatThingTypeAttributes);

        this.attribs = {};
    }

    _createClass(DatThingTypeAttributes, [{
        key: "has",
        value: function has(attr) {
            return this.attribs.hasOwnProperty(attr.toString());
        }
    }, {
        key: "get",
        value: function get(attr) {
            return this.attribs[attr];
        }
    }, {
        key: "set",
        value: function set(attr, value) {
            this.attribs[attr] = value;
        }
    }, {
        key: "remove",
        value: function remove(attr) {
            delete this.attribs[attr];
        }
    }]);

    return DatThingTypeAttributes;
}();

/***/ }),

/***/ 458:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(80);
module.exports = __webpack_require__(459);


/***/ }),

/***/ 459:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _const = __webpack_require__(1);

var _websiteImageGeneratorBase = __webpack_require__(62);

var _outfitImagePhpGeneratorCode = __webpack_require__(460);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var OutfitImageGenerator = function (_WebsiteImageGenerato) {
    _inherits(OutfitImageGenerator, _WebsiteImageGenerato);

    function OutfitImageGenerator() {
        _classCallCheck(this, OutfitImageGenerator);

        var _this = _possibleConstructorReturn(this, (OutfitImageGenerator.__proto__ || Object.getPrototypeOf(OutfitImageGenerator)).apply(this, arguments));

        _this.idleAnimation = true;
        return _this;
    }

    _createClass(OutfitImageGenerator, [{
        key: "init",
        value: function init() {
            this.otbRequired = false;
            _get(OutfitImageGenerator.prototype.__proto__ || Object.getPrototypeOf(OutfitImageGenerator.prototype), "init", this).call(this);
            this.idleAnimationCheckbox = document.getElementById('idleAnimation');
            this.forceEnableExtendedSpritesCheckbox = document.getElementById('forceEnableExtendedSprites');
            this.enableTransparencyCheckbox = document.getElementById('enableTransparency');
        }
    }, {
        key: "afterSetClientVersion",
        value: function afterSetClientVersion() {
            if (this.forceEnableExtendedSpritesCheckbox.checked) {
                this.client.enableFeature(_const.GameFeature.GameSpritesU32);
            }
            if (this.enableTransparencyCheckbox.checked) {
                this.client.enableFeature(_const.GameFeature.GameSpritesAlphaChannel);
            }
        }
    }, {
        key: "startImageGenerator",
        value: function startImageGenerator(imageGenerator, otbManager, datManager, spriteManager, zip) {
            this.idleAnimation = this.idleAnimationCheckbox.checked;
            this.generateOutfitImage(imageGenerator, otbManager, datManager, zip, 0);
        }
    }, {
        key: "generateOutfitImage",
        value: function generateOutfitImage(imageGenerator, otbManager, datManager, zip, outfitId) {
            var self = this;
            this.progressValue(outfitId, datManager.getCategory(_const.DatThingCategory.ThingCategoryCreature).length);
            if (outfitId > datManager.getCategory(_const.DatThingCategory.ThingCategoryCreature).length) {
                this.progressText('Packing images to ZIP file, please wait (it may take a while)');
                var outfitImagePhpGeneratorCode = new _outfitImagePhpGeneratorCode.OutfitImagePhpGeneratorCode();
                outfitImagePhpGeneratorCode.addFilesToZip(zip);
                zip.generateAsync({ type: "blob" }).then(function (blob) {
                    console.log('zip size', blob.size);
                    self.progressText('ZIP generated, it should start download now.');
                    self.downloadBlob('outfits.zip', blob);
                });
                return;
            }
            var outfitSprites = void 0;
            if (this.idleAnimation) {
                outfitSprites = imageGenerator.generateOutfitAnimationImages(outfitId, _const.FrameGroupType.FrameGroupIdle);
            }
            if (!outfitSprites || outfitSprites.length == 0) {
                outfitSprites = imageGenerator.generateOutfitAnimationImages(outfitId, _const.FrameGroupType.FrameGroupMoving);
            }
            if (!outfitSprites || outfitSprites.length == 0) {
                setTimeout(function () {
                    self.generateOutfitImage(imageGenerator, otbManager, datManager, zip, outfitId + 1);
                }, 1);
                return;
            }
            var outfitThingType = this.datManager.getOutfit(outfitId);
            if (outfitThingType && outfitThingType.hasBones()) {
                zip.file('outfits_anim/' + outfitId + '/bones.json', JSON.stringify(outfitThingType.getBones()));
            }
            var spritesToProcess = outfitSprites.length;

            var _loop = function _loop(outfitSprite) {
                var canvas = document.createElement('canvas');
                canvas.width = outfitSprite.sprite.getWidth();
                canvas.height = outfitSprite.sprite.getHeight();
                document.getElementsByTagName('body')[0].appendChild(canvas);
                var ctx = canvas.getContext("2d");
                var palette = ctx.getImageData(0, 0, outfitSprite.sprite.getWidth(), outfitSprite.sprite.getHeight());
                palette.data.set(new Uint8ClampedArray(outfitSprite.sprite.getPixels().m_buffer.buffer));
                ctx.putImageData(palette, 0, 0);
                if (self.imageFormat == 'png') {
                    var callback = function callback(blob) {
                        canvas.remove();
                        zip.file(outfitSprite.file + '.png', blob);
                        spritesToProcess--;
                        if (spritesToProcess == 0) {
                            setTimeout(function () {
                                self.generateOutfitImage(imageGenerator, otbManager, datManager, zip, outfitId + 1);
                            }, 1);
                        }
                    };
                    canvas.toBlob(callback);
                }
            };

            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = outfitSprites[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var outfitSprite = _step.value;

                    _loop(outfitSprite);
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }
        }
    }]);

    return OutfitImageGenerator;
}(_websiteImageGeneratorBase.WebsiteImageGeneratorBase);

var outfitImageGenerator = new OutfitImageGenerator();
outfitImageGenerator.init();

/***/ }),

/***/ 46:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var MarketData = exports.MarketData = function MarketData() {
  _classCallCheck(this, MarketData);
};

/***/ }),

/***/ 460:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Buffer) {

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var OutfitImagePhpGeneratorCode = exports.OutfitImagePhpGeneratorCode = function () {
    function OutfitImagePhpGeneratorCode() {
        _classCallCheck(this, OutfitImagePhpGeneratorCode);

        this.version = '0.1.6';
        this.files = {
            "libs\/gifCreator.php": "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",
            "libs\/outfitter.php": "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",
            "abuse_warning.png": "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",
            "animoutfit.php": "PD9waHANCg0KcmVxdWlyZV9vbmNlKCcuL2NvbmZpZy5waHAnKTsNCg0KaWYgKCFmaWxlX2V4aXN0cygnLi9jYWNoZS5nZW5lcmF0ZWQudHh0JykpIHsNCiAgICByZXF1aXJlX29uY2UoJy4vY2FjaGVHZW5lcmF0b3IucGhwJyk7DQogICAgZXhpdDsNCn0NCg0KaGVhZGVyKCdDYWNoZS1jb250cm9sOiBtYXgtYWdlPScgLiAoNjAgKiA2MCAqIDI0ICogMzY1KSk7DQpoZWFkZXIoJ0V4cGlyZXM6ICcgLiBnbWRhdGUoREFURV9SRkMxMTIzLCB0aW1lKCkgKyA2MCAqIDYwICogMjQgKiAzNjUpKTsNCmhlYWRlcignTGFzdC1Nb2RpZmllZDogJyAuIGdtZGF0ZSgnRCwgZCBNIFkgSDppOnMnLCAxMzM3KSAuICcgR01UJyk7DQppZiAoaXNzZXQoJF9TRVJWRVJbJ0hUVFBfSUZfTU9ESUZJRURfU0lOQ0UnXSkpIHsNCiAgICBoZWFkZXIoJ0hUVFAvMS4wIDMwNCBOb3QgTW9kaWZpZWQnKTsNCiAgICBoZWFkZXIoJ0NhY2hlLUNvbnRyb2w6IHB1YmxpYycpOw0KICAgIGhlYWRlcignUHJhZ21hOiBjYWNoZScpOw0KICAgIGV4aXQ7DQp9DQoNCi8vIEJsb2NrIHNpdGVzIHRoYXQgaG90bGluayB5b3VyIGhvc3QgYW5kIG92ZXJsb2FkIGl0DQokYWJ1c2Vyc0xpc3QgPSBhcnJheSgnYXVyZXJhLWdsb2JhbC5jb20nLCAnYmFkLXNlcnZlci5jb20nKTsNCmlmIChpc3NldCgkX1NFUlZFUlsnSFRUUF9SRUZFUkVSJ10pICYmIChpbl9hcnJheShwYXJzZV91cmwoJF9TRVJWRVJbJ0hUVFBfUkVGRVJFUiddLCBQSFBfVVJMX0hPU1QpLCAkYWJ1c2Vyc0xpc3QpIHx8DQogICAgICAgIGluX2FycmF5KHN1YnN0cihwYXJzZV91cmwoJF9TRVJWRVJbJ0hUVFBfUkVGRVJFUiddLCBQSFBfVVJMX0hPU1QpLCA0KSwgJGFidXNlcnNMaXN0KSkNCikgew0KICAgIGhlYWRlcignQ29udGVudC1UeXBlOiBpbWFnZS9wbmcnKTsNCiAgICByZWFkZmlsZSgnYWJ1c2Vfd2FybmluZy5wbmcnKTsNCiAgICBleGl0Ow0KfQ0KDQpyZXF1aXJlKCdsaWJzL291dGZpdHRlci5waHAnKTsNCnJlcXVpcmUoJ2xpYnMvZ2lmQ3JlYXRvci5waHAnKTsNCg0KT3V0Zml0dGVyOjokb3V0Zml0UGF0aCA9ICRvdXRmaXRJbWFnZXNQYXRoOw0KT3V0Zml0dGVyOjpzZXRSZXNpemVBbGxPdXRmaXRzVG82NHB4KCRyZXNpemVBbGxPdXRmaXRzVG82NHB4KTsNCg0KJGlkID0gMDsNCmlmIChpc3NldCgkX0dFVFsnaWQnXSkpIHsNCiAgICAkaWQgPSAoaW50KSRfR0VUWydpZCddOw0KfQ0KaWYgKCFPdXRmaXR0ZXI6OmxvYWREYXRhKCRpZCwgZmFsc2UpKSB7DQogICAgZXhpdCgnT3V0Zml0IGRvZXMgbm90IGV4aXN0IG9yIGZpbGUgY2FjaGUgaXMgbm90IGdlbmVyYXRlZC4nKTsNCn0NCg0KJG1vdW50ID0gMDsNCmlmIChpc3NldCgkX0dFVFsnbW91bnQnXSkpIHsNCiAgICAkbW91bnQgPSAoaW50KSRfR0VUWydtb3VudCddOw0KfQ0KaWYgKCRtb3VudCA+IDAgJiYgIU91dGZpdHRlcjo6bG9hZERhdGEoJG1vdW50LCB0cnVlKSkgew0KICAgIGV4aXQoJ01vdW50IG91dGZpdCBkb2VzIG5vdCBleGlzdCBvciBmaWxlIGNhY2hlIGlzIG5vdCBnZW5lcmF0ZWQuJyk7DQp9DQoNCiRoZWFkID0gMDsNCmlmIChpc3NldCgkX0dFVFsnaGVhZCddKSkgew0KICAgICRoZWFkID0gKGludCkkX0dFVFsnaGVhZCddOw0KfQ0KJGJvZHkgPSAwOw0KaWYgKGlzc2V0KCRfR0VUWydib2R5J10pKSB7DQogICAgJGJvZHkgPSAoaW50KSRfR0VUWydib2R5J107DQp9DQokbGVncyA9IDA7DQppZiAoaXNzZXQoJF9HRVRbJ2xlZ3MnXSkpIHsNCiAgICAkbGVncyA9IChpbnQpJF9HRVRbJ2xlZ3MnXTsNCn0NCiRmZWV0ID0gMDsNCmlmIChpc3NldCgkX0dFVFsnZmVldCddKSkgew0KICAgICRmZWV0ID0gKGludCkkX0dFVFsnZmVldCddOw0KfQ0KJGFkZG9ucyA9IDA7DQppZiAoaXNzZXQoJF9HRVRbJ2FkZG9ucyddKSkgew0KICAgICRhZGRvbnMgPSAoaW50KSRfR0VUWydhZGRvbnMnXTsNCn0NCiRkaXJlY3Rpb24gPSAzOw0KaWYgKGlzc2V0KCRfR0VUWydkaXJlY3Rpb24nXSkpIHsNCiAgICAkZGlyZWN0aW9uID0gKGludCkkX0dFVFsnZGlyZWN0aW9uJ107DQp9DQoNCiRmcmFtZXMgPSBbXTsNCiRkdXJhdGlvbnMgPSBbXTsNCg0KJG1vdmVBbmltRnJhbWVzID0gT3V0Zml0dGVyOjpnZXRPdXRmaXRGcmFtZXNOdW1iZXIoKTsNCg0KLy8gcm90YXRlIHBsYXllciwgQklHIElNQUdFUywgMjAtODAgS0IgcGVyIG91dGZpdCENCi8vZm9yKCRkaXJlY3Rpb24gPSAxOyAkZGlyZWN0aW9uIDw9IDQ7ICRkaXJlY3Rpb24rKykgDQpmb3IgKCRtb3ZlQW5pbUZyYW1lID0gMTsgJG1vdmVBbmltRnJhbWUgPD0gJG1vdmVBbmltRnJhbWVzOyArKyRtb3ZlQW5pbUZyYW1lKSB7DQogICAgJGZyYW1lc1tdID0gT3V0Zml0dGVyOjppbnN0YW5jZSgpLT5vdXRmaXQoDQogICAgICAgICRpZCwNCiAgICAgICAgJGFkZG9ucywNCiAgICAgICAgJGhlYWQsDQogICAgICAgICRib2R5LA0KICAgICAgICAkbGVncywNCiAgICAgICAgJGZlZXQsDQogICAgICAgICRtb3VudCwNCiAgICAgICAgJGRpcmVjdGlvbiwNCiAgICAgICAgJG1vdmVBbmltRnJhbWUNCiAgICApOw0KICAgICRkdXJhdGlvbnNbXSA9ICR3YWxrU3BlZWRzWyRtb3ZlQW5pbUZyYW1lc107DQp9DQokZ2MgPSBuZXcgR2lmQ3JlYXRvcigpOw0KJGdjLT5jcmVhdGUoJGZyYW1lcywgJGR1cmF0aW9ucywgMCk7DQokZ2lmQmluYXJ5ID0gJGdjLT5nZXRHaWYoKTsNCg0KaGVhZGVyKCdDb250ZW50LXR5cGU6IGltYWdlL2dpZicpOw0KZWNobyAkZ2lmQmluYXJ5Ow0K",
            "cacheGenerator.php": "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",
            "config.php": "PD9waHANCg0KJG91dGZpdEltYWdlc1BhdGggPSAnLi9vdXRmaXRzX2FuaW0vJzsNCi8vIHJlc2l6ZSBhbGwgb3V0Zml0cyB0byA2NHg2NCBwaXhlbHMsIHBsYWNlIHNtYWxsZXIgb3V0Zml0cyBpbiBib3R0b20tcmlnaHQgY29ybmVyDQokcmVzaXplQWxsT3V0Zml0c1RvNjRweCA9IGZhbHNlOw0KDQovLyBhbmltYXRpb24gc3BlZWRzOiBudW1iZXIgb2YgYW5pbWF0aW9uIGZyYW1lcyA9PiB0aW1lIGluIDAuMDEgb2Ygc2Vjb25kDQokd2Fsa1NwZWVkcyA9IFsNCiAgICAxID0+IDUwLA0KICAgIDIgPT4gMzUsDQogICAgMyA9PiAzMCwNCiAgICA0ID0+IDE1LA0KICAgIDUgPT4gMTUsDQogICAgNiA9PiAxNSwNCiAgICA3ID0+IDE1LA0KICAgIDggPT4gMTAsDQogICAgOSA9PiA4DQpdOw0KDQovKg0Kc29tZSBzZXJ2ZXIgY29uZmlndXJhdGlvbnMgbWF5IHByaW50IHdhcm5pbmdzIGZyb20gZ3JhcGhpY3MgbGlicmFyeQ0KdGhlc2Ugd2FybmluZ3MgYXJlIGludGVycHJldGVkIGFzIHBhcnQgb2YgaW1hZ2UgYW5kIG1ha2UgaW1hZ2UgdW5yZWFkYWJsZSBmb3Igd2ViIGJyb3dzZXJzDQppZiB5b3UgZ2V0IGJsYWNrL2VtcHR5IGltYWdlLCB5b3UgY2FuIHRyeSB0byB1bmNvbW1lbnQgbGluZSBiZWxvdyB0byBkaXNhYmxlIGFsbCB3YXJuaW5ncw0KKi8NCi8vIGVycm9yX3JlcG9ydGluZygwKTs=",
            "index.php": "PGh0bWwgbGFuZz0iZW4iPg0KPGhlYWQ+DQogICAgPG1ldGEgaHR0cC1lcXVpdj0iQ29udGVudC1UeXBlIiBjb250ZW50PSJ0ZXh0L2h0bWw7IGNoYXJzZXQ9dXRmLTgiPg0KICAgIDx0aXRsZT5UaWJpYSBPdXRmaXQgSW1hZ2VzIEdlbmVyYXRvciAwLjEuMjwvdGl0bGU+DQo8L2hlYWQ+DQo8Ym9keT4NCgk8c3BhbiBzdHlsZT0iZm9udC1zaXplOjIwcHgiPg0KICAgICAgICBUaGlzIGlzIGluZGV4IGZpbGUuPGJyLz4NCiAgICAgICAgT3BlbiA8Yj5hbmltb3V0Zml0LnBocDwvYj4gd2l0aCB2YWxpZCBwYXJhbWV0ZXJzIHRvIGdlbmVyYXRlIGFuaW1hdGVkIG91dGZpdCBpbWFnZS4gRm9yIGV4YW1wbGU6PGJyLz4NCiAgICAgICAgPGEgaHJlZj0iYW5pbW91dGZpdC5waHA\/aWQ9MTI4JmFkZG9ucz0zJmhlYWQ9MTIzJmJvZHk9MTImbGVncz0yMyZmZWV0PTMxJm1vdW50PTAmZGlyZWN0aW9uPTIiPg0KICAgICAgICAgICAgYW5pbW91dGZpdC5waHA\/aWQ9MTI4JmFkZG9ucz0zJmhlYWQ9MTIzJmJvZHk9MTImbGVncz0yMyZmZWV0PTMxJm1vdW50PTAmZGlyZWN0aW9uPTINCiAgICAgICAgPC9hPjxici8+DQogICAgICAgIDxici8+DQogICAgICAgIE9wZW4gPGI+b3V0Zml0LnBocDwvYj4gd2l0aCB2YWxpZCBwYXJhbWV0ZXJzIHRvIGdlbmVyYXRlIHN0YXRpYyBvdXRmaXQgaW1hZ2UuIEZvciBleGFtcGxlOjxici8+DQogICAgICAgIDxhIGhyZWY9Im91dGZpdC5waHA\/aWQ9MTI4JmFkZG9ucz0zJmhlYWQ9MTIzJmJvZHk9MTImbGVncz0yMyZmZWV0PTMxJm1vdW50PTAmZGlyZWN0aW9uPTIiPg0KICAgICAgICAgICAgb3V0Zml0LnBocD9pZD0xMjgmYWRkb25zPTMmaGVhZD0xMjMmYm9keT0xMiZsZWdzPTIzJmZlZXQ9MzEmbW91bnQ9MCZkaXJlY3Rpb249Mg0KICAgICAgICA8L2E+PGJyLz4NCiAgICA8L3NwYW4+DQo8L2JvZHk+DQo8L2hlYWQ+DQo8L2h0bWw+DQo=",
            "outfit.php": "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"
        };
    }

    _createClass(OutfitImagePhpGeneratorCode, [{
        key: "addFilesToZip",
        value: function addFilesToZip(zip) {
            for (var fileName in this.files) {
                var fileContent = this.files[fileName];
                var buffer = Buffer.from(fileContent, 'base64');
                zip.file(fileName, buffer);
            }
        }
    }]);

    return OutfitImagePhpGeneratorCode;
}();
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(86).Buffer))

/***/ }),

/***/ 47:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FrameGroup = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _size = __webpack_require__(7);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var FrameGroup = exports.FrameGroup = function () {
    function FrameGroup() {
        _classCallCheck(this, FrameGroup);

        this.m_size = new _size.Size();
        this.m_animator = null;
        this.m_animationPhases = 0;
        this.m_exactSize = 0;
        this.m_realSize = 0;
        this.m_numPatternX = 0;
        this.m_numPatternY = 0;
        this.m_numPatternZ = 0;
        this.m_layers = 0;
        this.m_spritesIndex = [];
    }

    _createClass(FrameGroup, [{
        key: "getSize",
        value: function getSize() {
            return this.m_size;
        }
    }, {
        key: "getWidth",
        value: function getWidth() {
            return this.m_size.width();
        }
    }, {
        key: "getHeight",
        value: function getHeight() {
            return this.m_size.height();
        }
    }, {
        key: "getRealSize",
        value: function getRealSize() {
            return this.m_realSize;
        }
    }, {
        key: "getLayers",
        value: function getLayers() {
            return this.m_layers;
        }
    }, {
        key: "getNumPatternX",
        value: function getNumPatternX() {
            return this.m_numPatternX;
        }
    }, {
        key: "getNumPatternY",
        value: function getNumPatternY() {
            return this.m_numPatternY;
        }
    }, {
        key: "getNumPatternZ",
        value: function getNumPatternZ() {
            return this.m_numPatternZ;
        }
    }, {
        key: "getAnimationPhases",
        value: function getAnimationPhases() {
            return this.m_animationPhases;
        }
    }, {
        key: "getAnimator",
        value: function getAnimator() {
            return this.m_animator;
        }
    }, {
        key: "getSprites",
        value: function getSprites() {
            return this.m_spritesIndex;
        }
    }, {
        key: "getSprite",
        value: function getSprite(index) {
            return this.m_spritesIndex[index];
        }
    }, {
        key: "getSpriteIndex",
        value: function getSpriteIndex(w, h, l, x, y, z, a) {
            var index = (((((a % this.m_animationPhases * this.m_numPatternZ + z) * this.m_numPatternY + y) * this.m_numPatternX + x) * this.m_layers + l) * this.m_size.height() + h) * this.m_size.width() + w;
            if (!(index < this.m_spritesIndex.length)) {
                throw new Error('index < this.m_spritesIndex.length');
            }
            return index;
        }
    }, {
        key: "getTextureIndex",
        value: function getTextureIndex(l, x, y, z) {
            return ((l * this.m_numPatternZ + z) * this.m_numPatternY + y) * this.m_numPatternX + x;
        }
    }]);

    return FrameGroup;
}();

/***/ }),

/***/ 48:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var BonesData = exports.BonesData = function BonesData() {
  _classCallCheck(this, BonesData);
};

/***/ }),

/***/ 49:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Pixel = exports.Pixel = function () {
    function Pixel(_r, _g, _b, _a) {
        _classCallCheck(this, Pixel);

        this._r = _r;
        this._g = _g;
        this._b = _b;
        this._a = _a;
    }

    _createClass(Pixel, [{
        key: "isTransparent",
        value: function isTransparent() {
            return this._r == 0 && this._g == 0 && this._b == 0 && this._a == 0;
        }
    }, {
        key: "r",
        get: function get() {
            return this._r;
        },
        set: function set(value) {
            this._r = value;
        }
    }, {
        key: "g",
        get: function get() {
            return this._g;
        },
        set: function set(value) {
            this._g = value;
        }
    }, {
        key: "b",
        get: function get() {
            return this._b;
        },
        set: function set(value) {
            this._b = value;
        }
    }, {
        key: "a",
        get: function get() {
            return this._a;
        },
        set: function set(value) {
            this._a = value;
        }
    }]);

    return Pixel;
}();

Pixel.BYTES_PER_PIXEL = 4;

/***/ }),

/***/ 50:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.OtbManager = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _log = __webpack_require__(4);

var _resources = __webpack_require__(13);

var _otbItemType = __webpack_require__(51);

var _outputFile = __webpack_require__(14);

var _outputBinaryTree = __webpack_require__(53);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

var OtbManager = exports.OtbManager = function () {
    function OtbManager(m_client) {
        _classCallCheck(this, OtbManager);

        this.m_client = m_client;
        this.m_loaded = false;
        this.m_lastId = 99;
        this.m_itemTypes = [];
        this.m_reverseItemTypes = [];
        this.m_otbMajorVersion = 0;
        this.m_otbMinorVersion = 0;
        this.m_otbBuildVersion = 0;
        this.m_otbDescription = '';
    }

    _createClass(OtbManager, [{
        key: "getItem",
        value: function getItem(id) {
            return this.m_itemTypes[id];
        }
    }, {
        key: "getItemByClientId",
        value: function getItemByClientId(id) {
            return this.m_reverseItemTypes[id];
        }
    }, {
        key: "isValidOtbId",
        value: function isValidOtbId(id) {
            return this.m_itemTypes[id] !== undefined;
        }
    }, {
        key: "getLastId",
        value: function getLastId() {
            return this.m_lastId;
        }
    }, {
        key: "setLastId",
        value: function setLastId(value) {
            this.m_lastId = value;
        }
    }, {
        key: "increaseLastId",
        value: function increaseLastId() {
            this.setLastId(this.getLastId() + 1);
        }
    }, {
        key: "getMajorVersion",
        value: function getMajorVersion() {
            return this.m_otbMajorVersion;
        }
    }, {
        key: "setMajorVersion",
        value: function setMajorVersion(version) {
            this.m_otbMajorVersion = version;
        }
    }, {
        key: "getMinorVersion",
        value: function getMinorVersion() {
            return this.m_otbMajorVersion;
        }
    }, {
        key: "setMinorVersion",
        value: function setMinorVersion(version) {
            this.m_otbMajorVersion = version;
        }
    }, {
        key: "getBuildVersion",
        value: function getBuildVersion() {
            return this.m_otbBuildVersion;
        }
    }, {
        key: "setBuildVersion",
        value: function setBuildVersion(version) {
            this.m_otbBuildVersion = version;
        }
    }, {
        key: "getDescription",
        value: function getDescription() {
            return this.m_otbDescription;
        }
        /**
         * Set description to 128 ASCII characters.
         * Format required by OTBI.
         * @param description
         */

    }, {
        key: "setDescription",
        value: function setDescription(description) {
            var newDescription = '';
            for (var i = 0; i < description.length, newDescription.length < 128; i++) {
                newDescription += String.fromCharCode(description.charCodeAt(i) % 256);
            }
            while (newDescription.length < 128) {
                newDescription += String.fromCharCode(0);
            }
            this.m_otbDescription = newDescription;
        }
    }, {
        key: "loadOtbFromUrl",
        value: function loadOtbFromUrl(url) {
            return __awaiter(this, void 0, void 0, /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
                var fin;
                return regeneratorRuntime.wrap(function _callee$(_context) {
                    while (1) {
                        switch (_context.prev = _context.next) {
                            case 0:
                                _context.next = 2;
                                return _resources.g_resources.openUrl(url);

                            case 2:
                                fin = _context.sent;
                                return _context.abrupt("return", this.loadOtb(fin));

                            case 4:
                            case "end":
                                return _context.stop();
                        }
                    }
                }, _callee, this);
            }));
        }
    }, {
        key: "loadOtb",
        value: function loadOtb(fin) {
            if (this.m_loaded) {
                throw new Error("OtbManager can load OTB only once");
            }
            this.m_loaded = true;
            try {
                var signature = fin.getU32();
                if (signature != 0) throw new Error("invalid otb file 1, " + signature);
                var root = fin.getBinaryTree();
                root.skip(1);
                signature = root.getU32();
                if (signature != 0) throw new Error("invalid otb file 2, " + signature);
                var rootAttr = root.getU8();
                if (rootAttr == 0x01) {
                    // OTB_ROOT_ATTR_VERSION
                    var size = root.getU16();
                    if (size != 4 + 4 + 4 + 128) throw new Error("invalid otb root attr version size");
                    this.m_otbMajorVersion = root.getU32();
                    this.m_otbMinorVersion = root.getU32();
                    this.m_otbBuildVersion = root.getU32();
                    this.m_otbDescription = root.getString(128);
                }
                var _iteratorNormalCompletion = true;
                var _didIteratorError = false;
                var _iteratorError = undefined;

                try {
                    for (var _iterator = root.getChildren()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                        var node = _step.value;

                        var itemType = new _otbItemType.OtbItemType();
                        itemType.unserialize(node, this);
                        this.addItemType(itemType);
                    }
                } catch (err) {
                    _didIteratorError = true;
                    _iteratorError = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion && _iterator.return) {
                            _iterator.return();
                        }
                    } finally {
                        if (_didIteratorError) {
                            throw _iteratorError;
                        }
                    }
                }

                return true;
            } catch (e) {
                _log.Log.error("Failed to load (OTB file): %s", e);
                return false;
            }
        }
    }, {
        key: "saveOtb",
        value: function saveOtb() {
            var fout = new _outputFile.OutputFile();
            fout.addU32(0);
            var root = new _outputBinaryTree.OutputBinaryTree(fout);
            root.addU32(0); // signature
            root.addU8(1); // OTB_ROOT_ATTR_VERSION
            root.addU16(4 + 4 + 4 + 128); // size
            root.addU32(this.m_otbMajorVersion);
            root.addU32(this.m_otbMinorVersion);
            root.addU32(this.m_otbBuildVersion);
            root.addString(this.m_otbDescription, 128); // build version
            var _iteratorNormalCompletion2 = true;
            var _didIteratorError2 = false;
            var _iteratorError2 = undefined;

            try {
                for (var _iterator2 = this.m_itemTypes[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                    var otbItemType = _step2.value;

                    if (otbItemType) {
                        root.startNode(-1);
                        otbItemType.serialize(root, this);
                        root.endNode();
                    }
                }
            } catch (err) {
                _didIteratorError2 = true;
                _iteratorError2 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion2 && _iterator2.return) {
                        _iterator2.return();
                    }
                } finally {
                    if (_didIteratorError2) {
                        throw _iteratorError2;
                    }
                }
            }

            root.endNode();
            return fout;
        }
    }, {
        key: "addItemType",
        value: function addItemType(itemType) {
            this.m_itemTypes[itemType.getServerId()] = itemType;
            this.m_reverseItemTypes[itemType.getClientId()] = itemType;
        }
    }]);

    return OtbManager;
}();

/***/ }),

/***/ 51:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.OtbItemType = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _const = __webpack_require__(1);

var _light = __webpack_require__(21);

var _otbItemTypeAttributes = __webpack_require__(52);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var OtbItemType = exports.OtbItemType = function () {
    function OtbItemType() {
        _classCallCheck(this, OtbItemType);

        this.m_null = true;
        this.m_category = _const.OtbItemCategory.ItemCategoryInvalid;
        this.m_flags = 0;
        this.m_attribs = new _otbItemTypeAttributes.OtbItemTypeAttributes();
    }

    _createClass(OtbItemType, [{
        key: "serialize",
        value: function serialize(node, m_otbManager) {
            node.addU8(this.m_category);
            node.addU32(this.m_flags);
            for (var attrString in this.m_attribs.attribs) {
                var attr = parseInt(attrString);
                node.addU8(attr);
                switch (attr) {
                    case _const.OtbItemTypeAttr.ItemTypeAttrServerId:
                        {
                            var serverId = this.m_attribs.get(attr);
                            if (m_otbManager.m_client.getClientVersion() < 960) {
                                if (serverId > 20000 && serverId < 20100) {
                                    serverId += 20000;
                                }
                            } else {
                                if (serverId > 30000 && serverId < 30100) {
                                    serverId += 30000;
                                }
                            }
                            node.addU16(2);
                            node.addU16(serverId);
                            break;
                        }
                    case _const.OtbItemTypeAttr.ItemTypeAttrClientId:
                        node.addU16(2);
                        node.addU16(this.m_attribs.get(attr));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrName:
                        node.addString(this.m_attribs.get(attr));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrSpeed:
                        node.addU16(2);
                        node.addU16(this.m_attribs.get(attr));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrWritable:
                        node.addU16(1);
                        node.addU8(this.m_attribs.get(attr));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrSpriteHash:
                        node.addString(this.m_attribs.get(attr));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrMinimapColor:
                        node.addU16(2);
                        node.addU16(this.m_attribs.get(attr));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttr07:
                        node.addU16(2);
                        node.addU16(this.m_attribs.get(attr));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttr08:
                        node.addU16(2);
                        node.addU16(this.m_attribs.get(attr));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrLight2:
                        node.addU16(4);
                        var light = this.m_attribs.get(attr);
                        node.addU16(light.intensity);
                        node.addU16(light.color);
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrTopOrder:
                        //1: borders
                        //2: ladders, signs, splashes
                        //3: doors etc
                        //4: creatures
                        node.addU16(1);
                        node.addU8(this.m_attribs.get(attr));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrWareId:
                        node.addU16(2);
                        node.addU16(this.m_attribs.get(attr));
                        break;
                    default:
                        node.addString(this.m_attribs.get(attr));
                }
            }
        }
    }, {
        key: "unserialize",
        value: function unserialize(node, m_otbManager) {
            this.m_null = false;
            this.m_category = node.getU8();
            this.m_flags = node.getU32();
            while (node.canRead()) {
                var attr = node.getU8();
                if (attr == 0 || attr == 0xFF) {
                    break;
                }
                var len = node.getU16();
                switch (attr) {
                    case _const.OtbItemTypeAttr.ItemTypeAttrServerId:
                        {
                            var serverId = node.getU16();
                            if (m_otbManager.m_client.getClientVersion() < 960) {
                                if (serverId > 20000 && serverId < 20100) {
                                    serverId -= 20000;
                                } else if (m_otbManager.getLastId() > 99 && m_otbManager.getLastId() != serverId - 1) {
                                    while (m_otbManager.getLastId() != serverId - 1) {
                                        var tmp = new OtbItemType();
                                        tmp.setServerId(m_otbManager.getLastId());
                                        m_otbManager.increaseLastId();
                                        m_otbManager.addItemType(tmp);
                                    }
                                }
                            } else {
                                if (serverId > 30000 && serverId < 30100) {
                                    serverId -= 30000;
                                } else if (m_otbManager.getLastId() > 99 && m_otbManager.getLastId() != serverId - 1) {
                                    while (m_otbManager.getLastId() != serverId - 1) {
                                        var _tmp = new OtbItemType();
                                        _tmp.setServerId(m_otbManager.getLastId());
                                        m_otbManager.increaseLastId();
                                        m_otbManager.addItemType(_tmp);
                                    }
                                }
                            }
                            this.setServerId(serverId);
                            m_otbManager.setLastId(serverId);
                            break;
                        }
                    case _const.OtbItemTypeAttr.ItemTypeAttrClientId:
                        this.setClientId(node.getU16());
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrName:
                        this.setName(node.getString(len));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrSpeed:
                        this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrSpeed, node.getU16());
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrWritable:
                        this.setWritable(true);
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrSpriteHash:
                        this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrSpriteHash, node.getString(len));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrMinimapColor:
                        this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrMinimapColor, node.getU16());
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttr07:
                        this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttr07, node.getU16());
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttr08:
                        this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttr08, node.getU16());
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrLight2:
                        this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrLight2, new _light.Light(node.getU16(), node.getU16()));
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrTopOrder:
                        //1: borders
                        //2: ladders, signs, splashes
                        //3: doors etc
                        //4: creatures
                        this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrTopOrder, node.getU8());
                        break;
                    case _const.OtbItemTypeAttr.ItemTypeAttrWareId:
                        this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrWareId, node.getU16());
                        break;
                    default:
                        this.m_attribs.set(attr, node.getString(len));
                        break;
                }
            }
        }
    }, {
        key: "isNull",
        value: function isNull() {
            return this.m_null;
        }
    }, {
        key: "setCategory",
        value: function setCategory(category) {
            this.m_category = category;
        }
    }, {
        key: "getCategory",
        value: function getCategory() {
            return this.m_category;
        }
    }, {
        key: "setFlags",
        value: function setFlags(flags) {
            this.m_flags = flags;
        }
    }, {
        key: "getFlags",
        value: function getFlags() {
            return this.m_flags;
        }
    }, {
        key: "hasFlag",
        value: function hasFlag(flag) {
            return (this.m_flags & flag) == flag;
        }
    }, {
        key: "setFlag",
        value: function setFlag(flag, value) {
            if (value) {
                this.m_flags |= flag;
            } else {
                this.m_flags &= ~flag;
            }
        }
    }, {
        key: "setServerId",
        value: function setServerId(serverId) {
            this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrServerId, serverId);
        }
    }, {
        key: "getServerId",
        value: function getServerId() {
            return this.m_attribs.get(_const.OtbItemTypeAttr.ItemTypeAttrServerId);
        }
    }, {
        key: "setClientId",
        value: function setClientId(clientId) {
            this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrClientId, clientId);
        }
    }, {
        key: "getClientId",
        value: function getClientId() {
            return this.m_attribs.get(_const.OtbItemTypeAttr.ItemTypeAttrClientId);
        }
    }, {
        key: "setName",
        value: function setName(name) {
            this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrName, name);
        }
    }, {
        key: "getName",
        value: function getName() {
            return this.m_attribs.get(_const.OtbItemTypeAttr.ItemTypeAttrName);
        }
    }, {
        key: "setDescription",
        value: function setDescription(description) {
            this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrDesc, description);
        }
    }, {
        key: "getDescription",
        value: function getDescription() {
            return this.m_attribs.get(_const.OtbItemTypeAttr.ItemTypeAttrDesc);
        }
    }, {
        key: "setWritable",
        value: function setWritable(value) {
            this.m_attribs.set(_const.OtbItemTypeAttr.ItemTypeAttrWritable, value);
        }
    }, {
        key: "isWritable",
        value: function isWritable() {
            return this.m_attribs.get(_const.OtbItemTypeAttr.ItemTypeAttrWritable);
        }
    }, {
        key: "getAttributes",
        value: function getAttributes() {
            return this.m_attribs;
        }
    }, {
        key: "setAttributes",
        value: function setAttributes(otbItemTypeAttributes) {
            this.m_attribs = otbItemTypeAttributes;
        }
    }]);

    return OtbItemType;
}();

/***/ }),

/***/ 52:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var OtbItemTypeAttributes = exports.OtbItemTypeAttributes = function () {
    function OtbItemTypeAttributes() {
        _classCallCheck(this, OtbItemTypeAttributes);

        this.attribs = {};
    }

    _createClass(OtbItemTypeAttributes, [{
        key: "has",
        value: function has(attr) {
            return this.attribs.hasOwnProperty(attr.toString());
        }
    }, {
        key: "get",
        value: function get(attr) {
            return this.attribs[attr];
        }
    }, {
        key: "set",
        value: function set(attr, value) {
            this.attribs[attr] = value;
        }
    }, {
        key: "remove",
        value: function remove(attr) {
            delete this.attribs[attr];
        }
    }]);

    return OtbItemTypeAttributes;
}();

/***/ }),

/***/ 53:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.OutputBinaryTree = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _binaryTree = __webpack_require__(25);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * In OutputBinaryTree we got to add BINARYTREE_ESCAPE_CHAR before every special character.
 * We also need to operate on bytes of numbers, so code is a bit dirty.
 */
var OutputBinaryTree = exports.OutputBinaryTree = function (_BinaryTree) {
    _inherits(OutputBinaryTree, _BinaryTree);

    function OutputBinaryTree(m_fin) {
        _classCallCheck(this, OutputBinaryTree);

        var _this = _possibleConstructorReturn(this, (OutputBinaryTree.__proto__ || Object.getPrototypeOf(OutputBinaryTree)).call(this, m_fin));

        _this.m_fin = m_fin;
        _this.m_pos = 0xFFFFFFFF;
        _this.m_startPos = 0;
        _this.startNode(0);
        return _this;
    }

    _createClass(OutputBinaryTree, [{
        key: "addU8",
        value: function addU8(value) {
            value = value % 256;
            if (value == _binaryTree.BinaryTree.BINARYTREE_NODE_START || value === _binaryTree.BinaryTree.BINARYTREE_NODE_END || value === _binaryTree.BinaryTree.BINARYTREE_ESCAPE_CHAR) {
                this.m_fin.addU8(_binaryTree.BinaryTree.BINARYTREE_ESCAPE_CHAR);
            }
            this.m_fin.addU8(value);
        }
    }, {
        key: "addU16",
        value: function addU16(value) {
            value = value % 65536;
            var b2 = Math.floor(value / 256);
            value -= b2 * 256;
            var b1 = value;
            this.addU8(b1);
            this.addU8(b2);
        }
    }, {
        key: "addU32",
        value: function addU32(value) {
            value = value % 4294967296;
            var b4 = Math.floor(value / 16777216);
            value -= b4 * 16777216;
            var b3 = Math.floor(value / 65536);
            value -= b3 * 65536;
            var b2 = Math.floor(value / 256);
            value -= b2 * 256;
            var b1 = value;
            this.addU8(b1);
            this.addU8(b2);
            this.addU8(b3);
            this.addU8(b4);
        }
    }, {
        key: "addString",
        value: function addString(value) {
            var length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : -1;

            if (length === -1) {
                this.addU16(value.length);
                length = value.length;
            }
            for (var i = 0; i < length; i++) {
                this.addU8(value.charCodeAt(i));
            }
        }
    }, {
        key: "addPos",
        value: function addPos(x, y, z) {
            this.addU16(x);
            this.addU16(y);
            this.addU8(z);
        }
    }, {
        key: "addPoint",
        value: function addPoint(point) {
            this.addU8(point.x);
            this.addU8(point.y);
        }
    }, {
        key: "startNode",
        value: function startNode(node) {
            this.m_fin.addU8(_binaryTree.BinaryTree.BINARYTREE_NODE_START);
            if (node !== -1) {
                this.addU8(node);
            }
        }
    }, {
        key: "endNode",
        value: function endNode() {
            this.m_fin.addU8(_binaryTree.BinaryTree.BINARYTREE_NODE_END);
        }
    }]);

    return OutputBinaryTree;
}(_binaryTree.BinaryTree);

OutputBinaryTree.BINARYTREE_ESCAPE_CHAR = 0xFD;
OutputBinaryTree.BINARYTREE_NODE_START = 0xFE;
OutputBinaryTree.BINARYTREE_NODE_END = 0xFF;

/***/ }),

/***/ 54:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ImageGenerator = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _spriteManager = __webpack_require__(15);

var _sprite = __webpack_require__(19);

var _size = __webpack_require__(7);

var _point = __webpack_require__(11);

var _const = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ImageGenerator = exports.ImageGenerator = function () {
    function ImageGenerator() {
        var datManager = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
        var sprManager = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
        var otbManager = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

        _classCallCheck(this, ImageGenerator);

        this.datManager = datManager;
        this.sprManager = sprManager;
        this.otbManager = otbManager;
    }

    _createClass(ImageGenerator, [{
        key: "generateItemImageByServerId",
        value: function generateItemImageByServerId(serverItemId) {
            var animationFrame = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

            if (this.otbManager === null) {
                throw new Error("otbManager is not set");
            }
            if (!this.otbManager.isValidOtbId(serverItemId)) {
                return null;
            }
            var clientItemId = this.otbManager.getItem(serverItemId).getClientId();
            if (!clientItemId) {
                return null;
            }
            return this.generateItemImageByClientId(clientItemId, animationFrame);
        }
    }, {
        key: "generateItemImagesByServerId",
        value: function generateItemImagesByServerId(serverItemId) {
            if (this.otbManager === null) {
                throw new Error("otbManager is not set");
            }
            if (!this.otbManager.isValidOtbId(serverItemId)) {
                return null;
            }
            var clientItemId = this.otbManager.getItem(serverItemId).getClientId();
            if (!clientItemId) {
                return null;
            }
            return this.generateItemImagesByClientId(clientItemId);
        }
    }, {
        key: "generateItemImageByClientId",
        value: function generateItemImageByClientId(clientItemId) {
            var animationFrame = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            var xPattern = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
            var yPattern = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
            var zPattern = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;

            if (this.datManager === null) {
                throw new Error("datManager is not set");
            }
            if (this.sprManager === null) {
                throw new Error("sprManager is not set");
            }
            var itemThingType = this.datManager.getItem(clientItemId);
            if (!itemThingType) {
                console.log('missing dat item', clientItemId);
                return null;
            }
            var frameGroup = itemThingType.getFrameGroup(_const.FrameGroupType.FrameGroupIdle);
            if (!frameGroup) {
                console.log('missing idle frameGroup item', clientItemId);
                return null;
            }
            var itemSprite = new _sprite.Sprite(new _size.Size(_spriteManager.SpriteManager.SPRITE_SIZE * frameGroup.m_size.width(), _spriteManager.SpriteManager.SPRITE_SIZE * frameGroup.m_size.height()));
            for (var l = 0; l < frameGroup.m_layers; ++l) {
                for (var w = 0; w < frameGroup.m_size.width(); ++w) {
                    for (var h = 0; h < frameGroup.m_size.height(); ++h) {
                        var spriteId = frameGroup.m_spritesIndex[frameGroup.getSpriteIndex(w, h, l, xPattern, yPattern, zPattern, animationFrame)];
                        var sprite = this.sprManager.getSprite(spriteId);
                        if (!sprite) {
                            if (spriteId != 0) {
                                console.log('missing sprite', spriteId);
                            }
                            continue;
                        }
                        itemSprite.blit(new _point.Point(_spriteManager.SpriteManager.SPRITE_SIZE * (frameGroup.m_size.width() - w - 1), _spriteManager.SpriteManager.SPRITE_SIZE * (frameGroup.m_size.height() - h - 1)), sprite);
                    }
                }
            }
            return itemSprite;
        }
        /**
         * Generates array of item images.
         * Array contains animation frames of item.
         * If item is stackable, array contains first animation frame of each stack stage.
         * @param clientItemId
         */

    }, {
        key: "generateItemImagesByClientId",
        value: function generateItemImagesByClientId(clientItemId) {
            if (this.datManager === null) {
                throw new Error("datManager is not set");
            }
            if (this.sprManager === null) {
                throw new Error("sprManager is not set");
            }
            var itemThingType = this.datManager.getItem(clientItemId);
            if (!itemThingType) {
                console.log('missing dat item', clientItemId);
                return null;
            }
            var frameGroup = itemThingType.getFrameGroup(_const.FrameGroupType.FrameGroupIdle);
            if (!frameGroup) {
                console.log('missing idle frameGroup item', clientItemId);
                return null;
            }
            var itemSprites = [];
            if (itemThingType.isStackable() && frameGroup.getNumPatternX() == 4 && frameGroup.getNumPatternY() == 2) {
                for (var patternY = 0; patternY < frameGroup.getNumPatternY(); ++patternY) {
                    for (var patternX = 0; patternX < frameGroup.getNumPatternX(); ++patternX) {
                        var itemSprite = this.generateItemImageByClientId(clientItemId, 0, patternX, patternY);
                        if (itemSprite) {
                            itemSprites.push(itemSprite);
                        }
                    }
                }
            } else {
                for (var animationPhase = 0; animationPhase < frameGroup.m_animationPhases; ++animationPhase) {
                    var _itemSprite = this.generateItemImageByClientId(clientItemId, animationPhase);
                    if (_itemSprite) {
                        itemSprites.push(_itemSprite);
                    }
                }
            }
            return itemSprites;
        }
    }, {
        key: "generateEffectImageById",
        value: function generateEffectImageById(clientItemId) {
            var animationFrame = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            var xPattern = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
            var yPattern = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
            var zPattern = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;

            if (this.datManager === null) {
                throw new Error("datManager is not set");
            }
            if (this.sprManager === null) {
                throw new Error("sprManager is not set");
            }
            var itemThingType = this.datManager.getEffect(clientItemId);
            if (!itemThingType) {
                console.log('missing dat effect', clientItemId);
                return null;
            }
            var frameGroup = itemThingType.getFrameGroup(_const.FrameGroupType.FrameGroupDefault);
            if (!frameGroup) {
                console.log('missing default frameGroup effect', clientItemId);
                return null;
            }
            var itemSprite = new _sprite.Sprite(new _size.Size(_spriteManager.SpriteManager.SPRITE_SIZE * frameGroup.m_size.width(), _spriteManager.SpriteManager.SPRITE_SIZE * frameGroup.m_size.height()));
            for (var l = 0; l < frameGroup.m_layers; ++l) {
                for (var w = 0; w < frameGroup.m_size.width(); ++w) {
                    for (var h = 0; h < frameGroup.m_size.height(); ++h) {
                        var spriteId = frameGroup.m_spritesIndex[frameGroup.getSpriteIndex(w, h, l, xPattern, yPattern, zPattern, animationFrame)];
                        var sprite = this.sprManager.getSprite(spriteId);
                        if (!sprite) {
                            if (spriteId != 0) {
                                console.log('missing sprite', spriteId);
                            }
                            continue;
                        }
                        itemSprite.blit(new _point.Point(_spriteManager.SpriteManager.SPRITE_SIZE * (frameGroup.m_size.width() - w - 1), _spriteManager.SpriteManager.SPRITE_SIZE * (frameGroup.m_size.height() - h - 1)), sprite);
                    }
                }
            }
            return itemSprite;
        }
        /**
         * Generates array of effect images.
         * Array contains animation frames of effect.
         * If item is stackable, array contains first animation frame of each stack stage.
         * @param effectId
         */

    }, {
        key: "generateEffectImagesById",
        value: function generateEffectImagesById(effectId) {
            if (this.datManager === null) {
                throw new Error("datManager is not set");
            }
            if (this.sprManager === null) {
                throw new Error("sprManager is not set");
            }
            var effectThingType = this.datManager.getEffect(effectId);
            if (!effectThingType) {
                console.log('missing dat effect', effectId);
                return null;
            }
            var frameGroup = effectThingType.getFrameGroup(_const.FrameGroupType.FrameGroupIdle);
            if (!frameGroup) {
                console.log('missing idle frameGroup item', effectId);
                return null;
            }
            var effectSprites = [];
            for (var animationPhase = 0; animationPhase < frameGroup.m_animationPhases; ++animationPhase) {
                var effectSprite = this.generateEffectImageById(effectId, animationPhase);
                if (effectSprite) {
                    effectSprites.push(effectSprite);
                }
            }
            return effectSprites;
        }
    }, {
        key: "generateMissileImageById",
        value: function generateMissileImageById(clientItemId) {
            var animationFrame = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            var xPattern = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
            var yPattern = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
            var zPattern = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;

            if (this.datManager === null) {
                throw new Error("datManager is not set");
            }
            if (this.sprManager === null) {
                throw new Error("sprManager is not set");
            }
            var itemThingType = this.datManager.getMissile(clientItemId);
            if (!itemThingType) {
                console.log('missing dat missile', clientItemId);
                return null;
            }
            var frameGroup = itemThingType.getFrameGroup(_const.FrameGroupType.FrameGroupDefault);
            if (!frameGroup) {
                console.log('missing default frameGroup missile', clientItemId);
                return null;
            }
            var itemSprite = new _sprite.Sprite(new _size.Size(_spriteManager.SpriteManager.SPRITE_SIZE * frameGroup.m_size.width(), _spriteManager.SpriteManager.SPRITE_SIZE * frameGroup.m_size.height()));
            for (var l = 0; l < frameGroup.m_layers; ++l) {
                for (var w = 0; w < frameGroup.m_size.width(); ++w) {
                    for (var h = 0; h < frameGroup.m_size.height(); ++h) {
                        var spriteId = frameGroup.m_spritesIndex[frameGroup.getSpriteIndex(w, h, l, xPattern, yPattern, zPattern, animationFrame)];
                        var sprite = this.sprManager.getSprite(spriteId);
                        if (!sprite) {
                            if (spriteId != 0) {
                                console.log('missing sprite', spriteId);
                            }
                            continue;
                        }
                        itemSprite.blit(new _point.Point(_spriteManager.SpriteManager.SPRITE_SIZE * (frameGroup.m_size.width() - w - 1), _spriteManager.SpriteManager.SPRITE_SIZE * (frameGroup.m_size.height() - h - 1)), sprite);
                    }
                }
            }
            return itemSprite;
        }
        /**
         * Generates array of missile images.
         * Array contains animation frames of missile.
         * If item is stackable, array contains first animation frame of each stack stage.
         * @param missileId
         */

    }, {
        key: "generateMissileImagesById",
        value: function generateMissileImagesById(missileId) {
            if (this.datManager === null) {
                throw new Error("datManager is not set");
            }
            if (this.sprManager === null) {
                throw new Error("sprManager is not set");
            }
            var missileThingType = this.datManager.getMissile(missileId);
            if (!missileThingType) {
                console.log('missing dat missile', missileId);
                return null;
            }
            var frameGroup = missileThingType.getFrameGroup(_const.FrameGroupType.FrameGroupIdle);
            if (!frameGroup) {
                console.log('missing idle frameGroup item', missileId);
                return null;
            }
            var missileSprites = [];
            for (var patternX = 0; patternX < frameGroup.getNumPatternX(); ++patternX) {
                for (var patternY = 0; patternY < frameGroup.getNumPatternY(); ++patternY) {
                    for (var animationPhase = 0; animationPhase < frameGroup.m_animationPhases; ++animationPhase) {
                        var missileSprite = this.generateMissileImageById(missileId, animationPhase, patternX, patternY);
                        if (missileSprite) {
                            missileSprites.push(missileSprite);
                        }
                    }
                }
            }
            return missileSprites;
        }
    }, {
        key: "generateOutfitAnimationImages",
        value: function generateOutfitAnimationImages(outfitId) {
            var frameGroupType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _const.FrameGroupType.FrameGroupMoving;

            if (this.datManager === null) {
                throw new Error("datManager is not set");
            }
            if (this.sprManager === null) {
                throw new Error("sprManager is not set");
            }
            var outfitThingType = this.datManager.getOutfit(outfitId);
            if (!outfitThingType) {
                console.log('missing dat outfit', outfitId);
                return null;
            }
            var frameGroup = outfitThingType.getFrameGroup(frameGroupType);
            if (!frameGroup) {
                console.log('missing frameGroup outfit', outfitId, frameGroupType);
                return null;
            }
            var sprites = [];
            for (var z = 0; z < frameGroup.m_numPatternZ; ++z) {
                for (var y = 0; y < frameGroup.m_numPatternY; ++y) {
                    for (var x = 0; x < frameGroup.m_numPatternX; ++x) {
                        for (var l = 0; l < frameGroup.m_layers; ++l) {
                            for (var a = 0; a < frameGroup.m_animationPhases; ++a) {
                                console.log('generate', 'outfits_anim/' + outfitId + '/' + (a + 1) + '/' + (z + 1) + '/' + (y + 1) + '/' + (x + 1));
                                var outfitSprite = new _sprite.Sprite(new _size.Size(_spriteManager.SpriteManager.SPRITE_SIZE * frameGroup.m_size.width(), _spriteManager.SpriteManager.SPRITE_SIZE * frameGroup.m_size.height()));
                                for (var w = 0; w < frameGroup.m_size.width(); ++w) {
                                    for (var h = 0; h < frameGroup.m_size.height(); ++h) {
                                        var spriteId = frameGroup.m_spritesIndex[frameGroup.getSpriteIndex(w, h, l, x, y, z, a)];
                                        var sprite = this.sprManager.getSprite(spriteId);
                                        if (!sprite) {
                                            if (spriteId != 0) {
                                                console.log('missing sprite', spriteId);
                                            }
                                            continue;
                                        }
                                        outfitSprite.blit(new _point.Point(_spriteManager.SpriteManager.SPRITE_SIZE * (frameGroup.m_size.width() - w - 1), _spriteManager.SpriteManager.SPRITE_SIZE * (frameGroup.m_size.height() - h - 1)), sprite);
                                    }
                                }
                                if (l == 1) {
                                    sprites.push({
                                        file: 'outfits_anim/' + outfitId + '/' + (a + 1) + '_' + (z + 1) + '_' + (y + 1) + '_' + (x + 1) + '_template',
                                        sprite: outfitSprite
                                    });
                                } else {
                                    sprites.push({
                                        file: 'outfits_anim/' + outfitId + '/' + (a + 1) + '_' + (z + 1) + '_' + (y + 1) + '_' + (x + 1),
                                        sprite: outfitSprite
                                    });
                                }
                            }
                        }
                    }
                }
            }
            return sprites;
        }
    }]);

    return ImageGenerator;
}();

/***/ }),

/***/ 62:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.WebsiteImageGeneratorBase = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _client = __webpack_require__(41);

var _datManager = __webpack_require__(42);

var _otbManager = __webpack_require__(50);

var _spriteManager = __webpack_require__(15);

var _inputFile = __webpack_require__(22);

var _imageGenerator = __webpack_require__(54);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var JSZip = __webpack_require__(93);

var WebsiteImageGeneratorBase = exports.WebsiteImageGeneratorBase = function () {
    function WebsiteImageGeneratorBase() {
        _classCallCheck(this, WebsiteImageGeneratorBase);

        this.otbRequired = true;
        this.imageFormat = 'png';
    }

    _createClass(WebsiteImageGeneratorBase, [{
        key: "init",
        value: function init() {
            this.clientVersionInput = document.getElementById('clientversion');
            this.sprPicker = document.getElementById('spr');
            this.datPicker = document.getElementById('dat');
            this.otbPicker = document.getElementById('otb');
            this.loadFilesButton = document.getElementById('loadFiles');
            this.generateImagesButton = document.getElementById('generateImages');
            var self = this;
            this.loadFilesButton.onclick = function () {
                self.loadFiles();
            };
            this.generateImagesButton.onclick = function () {
                if (!self.spriteManager || !self.datManager || !self.otbManager) {
                    self.progressText('Cannot generate images. First .spr, .dat and .otb files must be loaded.');
                    return;
                }
                var imageGenerator = new _imageGenerator.ImageGenerator(self.datManager, self.spriteManager, self.otbManager);
                var zip = new JSZip();
                self.startImageGenerator(imageGenerator, self.otbManager, self.datManager, self.spriteManager, zip);
            };
        }
    }, {
        key: "afterSetClientVersion",
        value: function afterSetClientVersion() {}
    }, {
        key: "startImageGenerator",
        value: function startImageGenerator(imageGenerator, otbManager, datManager, spriteManager, zip) {
            throw new Error("Method not implemented.");
        }
    }, {
        key: "loadFiles",
        value: function loadFiles() {
            var clientVersion = parseInt(this.clientVersionInput.value);
            this.progressText('Loading client version ' + clientVersion);
            this.client = new _client.Client();
            this.client.setClientVersion(clientVersion);
            this.afterSetClientVersion();
            this.progressText('Loading SPR file');
            var self = this;
            setTimeout(function () {
                self.loadSpr();
            }, 10);
        }
    }, {
        key: "loadSpr",
        value: function loadSpr() {
            if (this.sprPicker.files.length > 0) {
                this.spriteManager = new _spriteManager.SpriteManager(this.client);
                var file = this.sprPicker.files[0];
                var reader = new FileReader();
                reader.readAsArrayBuffer(file);
                var self = this;
                reader.onload = function (event) {
                    var sprLoaded = self.spriteManager.loadSpr(new _inputFile.InputFile(new DataView(event.target.result)));
                    if (sprLoaded) {
                        self.progressText('Loading DAT file');
                        setTimeout(function () {
                            self.loadDat();
                        }, 10);
                    } else {
                        self.spriteManager = null;
                        self.progressText('ERROR: Failed to load SPR file');
                    }
                };
            } else {
                this.progressText('ERROR: Please select SPR file');
            }
        }
    }, {
        key: "loadDat",
        value: function loadDat() {
            if (this.datPicker.files.length > 0) {
                this.datManager = new _datManager.DatManager(this.client);
                var file = this.datPicker.files[0];
                var reader = new FileReader();
                reader.readAsArrayBuffer(file);
                var self = this;
                reader.onload = function (event) {
                    var datLoaded = self.datManager.loadDat(new _inputFile.InputFile(new DataView(event.target.result)));
                    if (datLoaded) {
                        self.progressText('Loading OTB file');
                        setTimeout(function () {
                            self.loadOtb();
                        }, 10);
                    } else {
                        self.datManager = null;
                        self.progressText('ERROR: Failed to load DAT file');
                    }
                };
            } else {
                this.progressText('ERROR: Please select DAT file');
            }
        }
    }, {
        key: "loadOtb",
        value: function loadOtb() {
            if (this.otbRequired) {
                if (this.otbPicker.files.length > 0) {
                    this.otbManager = new _otbManager.OtbManager(this.client);
                    var file = this.otbPicker.files[0];
                    var reader = new FileReader();
                    reader.readAsArrayBuffer(file);
                    var self = this;
                    reader.onload = function (event) {
                        var otbLoaded = self.otbManager.loadOtb(new _inputFile.InputFile(new DataView(event.target.result)));
                        if (otbLoaded) {
                            self.progressText('Data loaded. You can click "Generate images" now.');
                        } else {
                            self.otbManager = null;
                            self.progressText('ERROR: Failed to load OTB file');
                        }
                    };
                } else {
                    this.progressText('ERROR: Please select OTB file');
                }
            } else {
                this.otbManager = new _otbManager.OtbManager(this.client);
                this.progressText('Data loaded. You can click "Generate images" now.');
            }
        }
    }, {
        key: "downloadBlob",
        value: function downloadBlob(filename, blob) {
            var a = document.createElement('a');
            var url = window.URL.createObjectURL(blob);
            a.href = url;
            a.download = filename;
            a.click();
            window.URL.revokeObjectURL(url);
            a.remove();
        }
    }, {
        key: "progressValue",
        value: function progressValue(done, todo) {
            var text = done + '/' + todo;
            this.progressText(text);
        }
    }, {
        key: "progressText",
        value: function progressText(text) {
            document.getElementById('progressBar').innerText = text;
        }
    }]);

    return WebsiteImageGeneratorBase;
}();

/***/ }),

/***/ 7:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Size = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _point = __webpack_require__(11);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Size = exports.Size = function () {
    function Size() {
        var wd = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : -1;
        var ht = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : -1;

        _classCallCheck(this, Size);

        this.wd = wd;
        this.ht = ht;
    }

    _createClass(Size, [{
        key: "equals",
        value: function equals(otherSize) {
            return this.wd == otherSize.wd && this.ht == otherSize.ht;
        }
    }, {
        key: "clone",
        value: function clone() {
            return new Size(this.wd, this.ht);
        }
    }, {
        key: "add",
        value: function add(size) {
            return new Size(this.wd + size.wd, this.ht + size.ht);
        }
    }, {
        key: "sub",
        value: function sub(size) {
            return new Size(this.wd - size.wd, this.ht - size.ht);
        }
    }, {
        key: "mul",
        value: function mul(ratio) {
            return new Size(this.wd * ratio, this.ht * ratio);
        }
    }, {
        key: "isNull",
        value: function isNull() {
            return this.wd == 0 && this.ht == 0;
        }
    }, {
        key: "isEmpty",
        value: function isEmpty() {
            return this.wd < 1 || this.ht < 1;
        }
    }, {
        key: "isValid",
        value: function isValid() {
            return this.wd >= 0 && this.ht >= 0;
        }
    }, {
        key: "width",
        value: function width() {
            return this.wd;
        }
    }, {
        key: "height",
        value: function height() {
            return this.ht;
        }
    }, {
        key: "resize",
        value: function resize(w, h) {
            this.wd = w;
            this.ht = h;
        }
    }, {
        key: "setWidth",
        value: function setWidth(w) {
            this.wd = w;
        }
    }, {
        key: "setHeight",
        value: function setHeight(h) {
            this.ht = h;
        }
    }, {
        key: "ratio",
        value: function ratio() {
            return this.wd / this.ht;
        }
    }, {
        key: "area",
        value: function area() {
            return this.wd * this.ht;
        }
    }, {
        key: "toPoint",
        value: function toPoint() {
            return new _point.Point(this.wd, this.ht);
        }
    }]);

    return Size;
}();

/***/ }),

/***/ 8:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DataBuffer = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _position = __webpack_require__(24);

var _pixel = __webpack_require__(49);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var DataBuffer = exports.DataBuffer = function () {
    function DataBuffer() {
        var m_capacity = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 64;

        _classCallCheck(this, DataBuffer);

        this.m_capacity = m_capacity;
        this.m_size = 0;
        this.m_buffer = new DataView(new ArrayBuffer(this.m_capacity));
    }

    _createClass(DataBuffer, [{
        key: "getUint8Array",
        value: function getUint8Array() {
            return new Uint8Array(this.m_buffer.buffer, 0, this.size());
        }
    }, {
        key: "reserve",
        value: function reserve(newSize) {
            if (newSize > this.m_capacity) {
                var buffer = new DataView(new ArrayBuffer(newSize));
                for (var i = 0; i < this.m_size; ++i) {
                    buffer.setUint8(i, this.m_buffer.getUint8(i));
                }
                this.m_buffer = buffer;
                this.m_capacity = newSize;
            }
        }
    }, {
        key: "grow",
        value: function grow(newSize) {
            if (newSize <= this.m_size) {
                return;
            }
            if (newSize > this.m_capacity) {
                var newcapacity = this.m_capacity;
                do {
                    newcapacity *= 2;
                } while (newcapacity < newSize);
                this.reserve(newcapacity);
            }
            this.m_size = newSize;
        }
    }, {
        key: "addU8",
        value: function addU8(value) {
            this.grow(this.m_size + 1);
            this.m_buffer.setUint8(this.m_size - 1, value);
            return 1;
        }
    }, {
        key: "addU16",
        value: function addU16(value) {
            this.grow(this.m_size + 2);
            this.m_buffer.setUint16(this.m_size - 2, value, true);
            return 2;
        }
    }, {
        key: "addU32",
        value: function addU32(value) {
            this.grow(this.m_size + 4);
            this.m_buffer.setUint32(this.m_size - 4, value, true);
            return 4;
        }
    }, {
        key: "add8",
        value: function add8(value) {
            this.grow(this.m_size + 1);
            this.m_buffer.setInt8(this.m_size - 1, value);
            return 1;
        }
    }, {
        key: "add16",
        value: function add16(value) {
            this.grow(this.m_size + 2);
            this.m_buffer.setInt16(this.m_size - 2, value, true);
            return 2;
        }
    }, {
        key: "add32",
        value: function add32(value) {
            this.grow(this.m_size + 4);
            this.m_buffer.setInt32(this.m_size - 4, value, true);
            return 4;
        }
    }, {
        key: "addString",
        value: function addString(value) {
            this.grow(this.m_size + 2 + value.length);
            this.m_buffer.setUint16(this.m_size - 2 - value.length, value.length, true);
            for (var i = 0; i < value.length; i++) {
                this.m_buffer.setUint8(this.m_size - value.length + i, value.charCodeAt(i));
            }
            return 2 + value.length;
        }
    }, {
        key: "addPixel",
        value: function addPixel(pixel, bytesPerPixel) {
            if (bytesPerPixel == 4) {
                this.grow(this.m_size + 4);
                this.m_buffer.setUint8(this.m_size - 4, pixel.r);
                this.m_buffer.setUint8(this.m_size - 3, pixel.g);
                this.m_buffer.setUint8(this.m_size - 2, pixel.b);
                this.m_buffer.setUint8(this.m_size - 1, pixel.a);
                return 4;
            } else {
                this.grow(this.m_size + 3);
                this.m_buffer.setUint8(this.m_size - 3, pixel.r);
                this.m_buffer.setUint8(this.m_size - 2, pixel.g);
                this.m_buffer.setUint8(this.m_size - 1, pixel.b);
                return 3;
            }
        }
    }, {
        key: "setU8",
        value: function setU8(offset, value) {
            this.grow(offset + 1);
            this.m_buffer.setUint8(offset, value);
        }
    }, {
        key: "setU32",
        value: function setU32(offset, value) {
            this.grow(offset + 4);
            this.m_buffer.setInt32(offset - 4, value, true);
        }
    }, {
        key: "setRgbaPixel",
        value: function setRgbaPixel(offset, pixel) {
            offset = offset * 4;
            this.setU8(offset, pixel.r);
            this.setU8(offset + 1, pixel.g);
            this.setU8(offset + 2, pixel.b);
            this.setU8(offset + 3, pixel.a);
        }
    }, {
        key: "getU8",
        value: function getU8(offset) {
            if (offset + 1 > this.size()) throw new Error("DataBuffer: getU8 failed");
            return this.m_buffer.getUint8(offset);
        }
    }, {
        key: "getU16",
        value: function getU16(offset) {
            if (offset + 2 > this.size()) throw new Error("DataBuffer: getU16 failed");
            return this.m_buffer.getUint16(offset, true);
        }
    }, {
        key: "getU32",
        value: function getU32(offset) {
            if (offset + 4 > this.size()) throw new Error("DataBuffer: getU32 failed");
            return this.m_buffer.getUint32(offset, true);
        }
    }, {
        key: "get8",
        value: function get8(offset) {
            if (offset + 1 > this.size()) throw new Error("DataBuffer: get8 failed");
            return this.m_buffer.getInt8(offset);
        }
    }, {
        key: "get16",
        value: function get16(offset) {
            if (offset + 2 > this.size()) throw new Error("DataBuffer: get16 failed");
            return this.m_buffer.getInt16(offset, true);
        }
    }, {
        key: "get32",
        value: function get32(offset) {
            if (offset + 4 > this.size()) throw new Error("DataBuffer: get32 failed");
            return this.m_buffer.getInt32(offset, true);
        }
    }, {
        key: "getDouble",
        value: function getDouble(offset) {
            if (offset + 8 > this.size()) throw new Error("DataBuffer: getDouble failed");
            return this.m_buffer.getFloat64(offset, true);
        }
    }, {
        key: "getString",
        value: function getString(offset) {
            var length = this.getU16(offset);
            var text = '';
            for (var i = 0; i < length; i++) {
                text += String.fromCharCode(this.getU8(offset + 2 + i));
            }
            return text;
        }
    }, {
        key: "getBytes",
        value: function getBytes(offset, bytesCount) {
            if (bytesCount == -1) bytesCount = this.size() - offset;
            if (offset + bytesCount > this.size()) throw new Error("Invalid offset. Cannot read.");
            return this.m_buffer.buffer.slice(offset, offset + bytesCount);
        }
    }, {
        key: "getPosition",
        value: function getPosition(offset) {
            if (offset + 5 > this.size()) throw new Error("DataBuffer: getPosition failed");
            return new _position.Position(this.getU16(offset), this.getU16(offset + 2), this.getU8(offset + 4));
        }
    }, {
        key: "getRgbaPixel",
        value: function getRgbaPixel(offset) {
            offset = offset * 4;
            if (offset + 4 > this.size()) throw new Error("DataBuffer: getRgbaPixel failed");
            return new _pixel.Pixel(this.getU8(offset), this.getU8(offset + 1), this.getU8(offset + 2), this.getU8(offset + 3));
        }
    }, {
        key: "reserveRgbaPixel",
        value: function reserveRgbaPixel(offset) {
            this.grow(offset * 4 + 4);
        }
    }, {
        key: "size",
        value: function size() {
            return this.m_size;
        }
    }, {
        key: "clear",
        value: function clear() {
            this.m_size = 0;
            this.m_capacity = 64;
            this.m_buffer = new DataView(new ArrayBuffer(this.m_capacity));
        }
    }]);

    return DataBuffer;
}();

/***/ }),

/***/ 95:
/***/ (function(module, exports) {

/* (ignored) */

/***/ }),

/***/ 96:
/***/ (function(module, exports) {

/* (ignored) */

/***/ })

},[458]);